/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.demo;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import eleme.openapi.sdk.api.entity.other.OMessage;
import eleme.openapi.sdk.api.entity.shop.OShop;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.api.json.gson.Gson;
import eleme.openapi.sdk.api.service.OrderService;
import eleme.openapi.sdk.api.service.ShopService;
import eleme.openapi.sdk.api.service.UserService;
import eleme.openapi.sdk.api.utils.CallbackValidationUtil;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.OAuthClient;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.utils.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServerDemo {
    private static Gson gson = new Gson();
    private static Config config = null;
    private static Token token = null;
    private static OAuthClient client = null;
    private static final boolean isSandbox = true;
    private static final String key = "your app key";
    private static final String secret = "your app secret";
    private static String callbackUrl = "your callback url";
    private static String scope = "all";
    private static String state = "";

    public static void main(String[] args) {
        try {
            HttpServerDemo.start(8899);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void start(Integer port) throws IOException {
        InetSocketAddress address = new InetSocketAddress(port);
        HttpServer server = HttpServer.create(address, 0);
        if (server != null) {
            server.createContext("/demo", new DemoHandler());
            server.createContext("/api", new ApiHandler());
            server.createContext("/getInfo", new Shop());
            server.setExecutor(null);
            server.start();
        }
    }

    private static void response(HttpExchange t, String responseMsg) {
        try {
            t.sendResponseHeaders(200, responseMsg.getBytes().length);
            OutputStream os = t.getResponseBody();
            os.write(responseMsg.getBytes("UTF-8"));
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String rtnHtml() throws IOException {
        int length;
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("page/demo.html");
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = resourceAsStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    private static Map<String, String> queryToMap(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String param : query.split("&")) {
            String[] pair = param.split("=");
            if (pair.length > 1) {
                result.put(pair[0], pair[1]);
                continue;
            }
            result.put(pair[0], "");
        }
        return result;
    }

    static {
        config = new Config(true, key, secret);
        client = new OAuthClient(config);
        token = client.getTokenByCode("", "");
    }

    private static class GetInfoRequest {
        private String userId;
        private String shopId;

        private GetInfoRequest() {
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getShopId() {
            return this.shopId;
        }

        public void setShopId(String shopId) {
            this.shopId = shopId;
        }
    }

    private static class ResponseResult {
        private Result result;

        private ResponseResult() {
        }

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        static class Result {
            private String OAuthUrl;
            private String shopName;

            Result() {
            }

            public String getOAuthUrl() {
                return this.OAuthUrl;
            }

            public void setOAuthUrl(String OAuthUrl) {
                this.OAuthUrl = OAuthUrl;
            }

            public String getShopName() {
                return this.shopName;
            }

            public void setShopName(String shopName) {
                this.shopName = shopName;
            }
        }
    }

    static class ApiHandler
    implements HttpHandler {
        ApiHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handle(HttpExchange t) throws IOException {
            code = 200;
            response = "ok";
            oMessage = null;
            try {
                block12: {
                    if (!"GET".equals(t.getRequestMethod())) break block12;
                    var10_5 = null;
                    responseMap = new HashMap<String, String>();
                    responseMap.put("message", response);
                    ** GOTO lbl69
                }
                is = t.getRequestBody();
                in = new BufferedReader(new InputStreamReader(is));
                body = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    body.append(line);
                }
                oMessage = HttpServerDemo.access$000().fromJson(body.toString(), OMessage.class);
                if (!CallbackValidationUtil.isValidMessage(oMessage, "your app secret")) {
                    throw new Exception("invalid post data : " + body);
                }
                ** GOTO lbl84
            }
            catch (Exception e) {
                e.printStackTrace();
                code = 500;
                response = e.getMessage();
                var10_7 = null;
                responseMap = new HashMap<String, String>();
                responseMap.put("message", response);
                message = HttpServerDemo.access$000().toJson(responseMap);
                t.sendResponseHeaders(code, message.length());
                os = t.getResponseBody();
                os.write(message.getBytes());
                os.close();
                if (null == oMessage) return;
                if (oMessage.getType() != 10) return;
                orderService = new OrderService(HttpServerDemo.access$800(), HttpServerDemo.access$200());
                msg = HttpServerDemo.access$000().fromJson(oMessage.getMessage(), OMessage.Message.class);
                try {
                    var16_33 = orderService.confirmOrder(msg.getOrder_id());
                    return;
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                    return;
                }
            }
            {
                catch (Throwable var9_42) {
                    var10_8 = null;
                    responseMap = new HashMap<String, String>();
                    responseMap.put("message", response);
                    message = HttpServerDemo.access$000().toJson(responseMap);
                    t.sendResponseHeaders(code, message.length());
                    os = t.getResponseBody();
                    os.write(message.getBytes());
                    os.close();
                    if (null == oMessage) throw var9_42;
                    if (oMessage.getType() != 10) throw var9_42;
                    orderService = new OrderService(HttpServerDemo.access$800(), HttpServerDemo.access$200());
                    msg = HttpServerDemo.access$000().fromJson(oMessage.getMessage(), OMessage.Message.class);
                    ** try [egrp 2[TRYBLOCK] [6 : 287->302)] { 
lbl64:
                    // 1 sources

                    var16_35 = orderService.confirmOrder(msg.getOrder_id());
                    throw var9_42;
lbl66:
                    // 1 sources

                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                    throw var9_42;
                }
lbl69:
                // 1 sources

                message = HttpServerDemo.access$000().toJson(responseMap);
                t.sendResponseHeaders(code, message.length());
                os = t.getResponseBody();
                os.write(message.getBytes());
                os.close();
                if (null == oMessage) return;
                if (oMessage.getType() != 10) return;
                orderService = new OrderService(HttpServerDemo.access$800(), HttpServerDemo.access$200());
                msg = HttpServerDemo.access$000().fromJson(oMessage.getMessage(), OMessage.Message.class);
                ** try [egrp 2[TRYBLOCK] [6 : 287->302)] { 
lbl79:
                // 1 sources

                var16_29 = orderService.confirmOrder(msg.getOrder_id());
                return;
lbl81:
                // 1 sources

                catch (ServiceException e) {
                    e.printStackTrace();
                }
                return;
lbl84:
                // 1 sources

                var10_6 = null;
                responseMap = new HashMap<String, String>();
                responseMap.put("message", response);
                message = HttpServerDemo.access$000().toJson(responseMap);
                t.sendResponseHeaders(code, message.length());
                os = t.getResponseBody();
                os.write(message.getBytes());
                os.close();
                if (null == oMessage) return;
                if (oMessage.getType() != 10) return;
                orderService = new OrderService(HttpServerDemo.access$800(), HttpServerDemo.access$200());
                msg = HttpServerDemo.access$000().fromJson(oMessage.getMessage(), OMessage.Message.class);
                try {}
                catch (ServiceException e) {}
                e.printStackTrace();
                return;
                var16_31 = orderService.confirmOrder(msg.getOrder_id());
                return;
            }
        }
    }

    static class DemoHandler
    implements HttpHandler {
        DemoHandler() {
        }

        public void handle(HttpExchange t) throws IOException {
            String query = t.getRequestURI().getQuery();
            String initHtml = HttpServerDemo.rtnHtml();
            if (StringUtils.isEmpty(query)) {
                HttpServerDemo.response(t, initHtml);
                return;
            }
            Map stringStringMap = HttpServerDemo.queryToMap(t.getRequestURI().getQuery());
            String code = (String)stringStringMap.get("code");
            if (StringUtils.isEmpty(code)) {
                HttpServerDemo.response(t, initHtml);
                return;
            }
            long userId = 0L;
            String shopName = null;
            try {
                Token token = client.getTokenByCode(code, callbackUrl);
                if (!token.isSuccess()) {
                    System.out.println(token.getError());
                    System.out.println(token.getError_description());
                }
                UserService userService = new UserService(config, token);
                System.out.println(userService.getUser().getUserName());
                userId = userService.getUser().getUserId();
                shopName = userService.getUser().getAuthorizedShops().get(0).getName();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            String responseHtml = initHtml.replace("{{ userId }}", String.valueOf(userId)).replace("{{ shopName }}", shopName);
            System.out.println(initHtml);
            HttpServerDemo.response(t, responseHtml);
        }
    }

    static class Shop
    implements HttpHandler {
        Shop() {
        }

        public void handle(HttpExchange t) throws IOException {
            if (t.getRequestMethod().equals("POST")) {
                String line;
                InputStream is = t.getRequestBody();
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                StringBuilder body = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    body.append(line);
                }
                GetInfoRequest request = gson.fromJson(body.toString(), GetInfoRequest.class);
                String shopId = request.getShopId();
                ResponseResult result = new ResponseResult();
                ResponseResult.Result rResult = new ResponseResult.Result();
                try {
                    if (token == null || !token.isSuccess()) {
                        rResult.setOAuthUrl(client.getAuthUrl(callbackUrl, scope, state));
                        result.setResult(rResult);
                        String resultJson = gson.toJson(result);
                        HttpServerDemo.response(t, resultJson);
                        return;
                    }
                    ShopService shopService = new ShopService(config, token);
                    OShop shop = shopService.getShop(Long.valueOf(shopId));
                    rResult.setShopName(shop.getName());
                    result.setResult(rResult);
                    String resultJson = gson.toJson(result);
                    HttpServerDemo.response(t, resultJson);
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

