/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.deserializer;

import eleme.openapi.sdk.api.json.gson.JsonDeserializationContext;
import eleme.openapi.sdk.api.json.gson.JsonDeserializer;
import eleme.openapi.sdk.api.json.gson.JsonElement;
import eleme.openapi.sdk.api.json.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateDeserializer
implements JsonDeserializer<Date> {
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String dateTimeStr = json.getAsString();
        dateTimeStr = dateTimeStr.replace("T", " ");
        try {
            return simpleDateFormat.parse(dateTimeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

