/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.json.gson.internal.bind;

import eleme.openapi.sdk.api.json.gson.Gson;
import eleme.openapi.sdk.api.json.gson.JsonSyntaxException;
import eleme.openapi.sdk.api.json.gson.TypeAdapter;
import eleme.openapi.sdk.api.json.gson.TypeAdapterFactory;
import eleme.openapi.sdk.api.json.gson.reflect.TypeToken;
import eleme.openapi.sdk.api.json.gson.stream.JsonReader;
import eleme.openapi.sdk.api.json.gson.stream.JsonToken;
import eleme.openapi.sdk.api.json.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlDateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    @Override
    public synchronized Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            long utilDate = this.format.parse(in.nextString()).getTime();
            return new Date(utilDate);
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Date value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

