/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.oauth.impl;

import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.IOAuthClient;
import eleme.openapi.sdk.oauth.OAuthRequest;
import eleme.openapi.sdk.oauth.parser.ObjectJsonParser;
import eleme.openapi.sdk.oauth.response.ErrorResponse;
import eleme.openapi.sdk.utils.WebUtils;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIOAuthClient
implements IOAuthClient {
    private int connectTimeout = 15000;
    private int readTimeout = 30000;
    private boolean useSimplifyJson = false;
    private Config context;

    public DefaultIOAuthClient(Config context) {
        this.context = context;
    }

    @Override
    public <T extends ErrorResponse> T execute(OAuthRequest<T> request) {
        try {
            String respJson = WebUtils.doPost(this.context, this.context.getOauthTokenUrl(), request.getBodyMap(), "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
            ObjectJsonParser<T> parser = new ObjectJsonParser<T>(request.getResponseClass(), this.useSimplifyJson);
            return parser.parse(respJson);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

