/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.order.OCommodity;
import eleme.openapi.sdk.api.entity.order.ODeliveryRecord;
import eleme.openapi.sdk.api.entity.order.OOrder;
import eleme.openapi.sdk.api.entity.order.ORefundOrder;
import eleme.openapi.sdk.api.enumeration.order.OInvalidateType;
import eleme.openapi.sdk.api.enumeration.order.ReplyReminderType;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="eleme.order")
public class OrderService
extends BaseNopService {
    public OrderService(Config config, Token token) {
        super(config, token, OrderService.class);
    }

    public OOrder getOrder(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (OOrder)this.call("eleme.order.getOrder", params);
    }

    public Map<String, OOrder> mgetOrders(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.mgetOrders", params);
    }

    public OOrder confirmOrder(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (OOrder)this.call("eleme.order.confirmOrder", params);
    }

    public OOrder cancelOrder(String orderId, OInvalidateType type, String remark) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("type", (Object)type);
        params.put("remark", remark);
        return (OOrder)this.call("eleme.order.cancelOrder", params);
    }

    public OOrder agreeRefund(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (OOrder)this.call("eleme.order.agreeRefund", params);
    }

    public OOrder disagreeRefund(String orderId, String reason) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("reason", reason);
        return (OOrder)this.call("eleme.order.disagreeRefund", params);
    }

    public List<ODeliveryRecord> getDeliveryStateRecord(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (List)this.call("eleme.order.getDeliveryStateRecord", params);
    }

    public Map<String, ODeliveryRecord> batchGetDeliveryStates(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.batchGetDeliveryStates", params);
    }

    public OOrder deliveryBySelf(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (OOrder)this.call("eleme.order.deliveryBySelf", params);
    }

    public OOrder noMoreDelivery(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (OOrder)this.call("eleme.order.noMoreDelivery", params);
    }

    public OOrder receivedOrder(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (OOrder)this.call("eleme.order.receivedOrder", params);
    }

    public void replyReminder(String remindId, ReplyReminderType type, String content) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("remindId", remindId);
        params.put("type", (Object)type);
        params.put("content", content);
        this.call("eleme.order.replyReminder", params);
    }

    public Map<String, OCommodity> getCommodities(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (Map)this.call("eleme.order.getCommodities", params);
    }

    public Map<String, Map<String, OCommodity>> mgetCommodities(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.mgetCommodities", params);
    }

    public ORefundOrder getRefundOrder(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (ORefundOrder)this.call("eleme.order.getRefundOrder", params);
    }

    public Map<String, ORefundOrder> mgetRefundOrders(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.mgetRefundOrders", params);
    }

    public void cancelDelivery(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        this.call("eleme.order.cancelDelivery", params);
    }

    public void callDelivery(String orderId, int fee) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("fee", fee);
        this.call("eleme.order.callDelivery", params);
    }
}

