/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.oauth.parser;

import eleme.openapi.sdk.oauth.OAuthException;
import eleme.openapi.sdk.oauth.mapping.ApiListField;
import eleme.openapi.sdk.oauth.mapping.TokenField;
import eleme.openapi.sdk.oauth.parser.Reader;
import eleme.openapi.sdk.oauth.response.ErrorResponse;
import eleme.openapi.sdk.utils.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converters {
    public static boolean isCheckJsonType = false;
    private static final Map<String, Set<String>> baseProps = new HashMap<String, Set<String>>();
    private static final Map<String, Field> fieldCache = new ConcurrentHashMap<String, Field>();

    private Converters() {
    }

    public static <T> T convert(Class<T> clazz, Reader reader) {
        T rsp = null;
        try {
            PropertyDescriptor[] pds;
            rsp = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                Object value;
                ApiListField jsonListField;
                Method method = pd.getWriteMethod();
                if (method == null) continue;
                String itemName = pd.getName();
                String listName = null;
                Field field = null;
                Set<String> stopProps = baseProps.get(clazz.getSuperclass().getName());
                field = stopProps != null && stopProps.contains(itemName) ? Converters.getField(clazz.getSuperclass(), pd) : Converters.getField(clazz, pd);
                if (field == null) continue;
                TokenField jsonField = field.getAnnotation(TokenField.class);
                if (jsonField != null) {
                    itemName = jsonField.value();
                }
                if ((jsonListField = field.getAnnotation(ApiListField.class)) != null) {
                    listName = jsonListField.value();
                }
                if (!reader.hasReturnField(itemName) && (listName == null || !reader.hasReturnField(listName))) continue;
                Class<?> typeClass = field.getType();
                if (String.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof String) {
                        method.invoke(rsp, value.toString());
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new OAuthException(itemName + " is not a String");
                    }
                    if (value != null) {
                        method.invoke(rsp, value.toString());
                        continue;
                    }
                    method.invoke(rsp, "");
                    continue;
                }
                if (Long.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Long) {
                        method.invoke(rsp, (Long)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new OAuthException(itemName + " is not a Number(Long)");
                    }
                    if (!StringUtils.isNumeric(value)) continue;
                    method.invoke(rsp, Long.valueOf(value.toString()));
                    continue;
                }
                if (Boolean.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Boolean) {
                        method.invoke(rsp, (Boolean)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new OAuthException(itemName + " is not a Boolean");
                    }
                    if (value == null) continue;
                    method.invoke(rsp, Boolean.valueOf(value.toString()));
                    continue;
                }
                if (Date.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (!(value instanceof String)) continue;
                    method.invoke(rsp, StringUtils.parseDateTime(value.toString()));
                    continue;
                }
                if (List.class.isAssignableFrom(typeClass)) {
                    Class subType;
                    List<?> listObjs;
                    ParameterizedType paramType;
                    Type[] genericTypes;
                    Type fieldType = field.getGenericType();
                    if (!(fieldType instanceof ParameterizedType) || (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) == null || genericTypes.length <= 0 || !(genericTypes[0] instanceof Class) || (listObjs = reader.getListObjects(listName, itemName, subType = (Class)genericTypes[0])) == null) continue;
                    method.invoke(rsp, listObjs);
                    continue;
                }
                if (Integer.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Integer) {
                        method.invoke(rsp, (Integer)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new OAuthException(itemName + " is not a Number(Integer)");
                    }
                    if (!StringUtils.isNumeric(value)) continue;
                    method.invoke(rsp, Integer.valueOf(value.toString()));
                    continue;
                }
                if (Double.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Double) {
                        method.invoke(rsp, (Double)value);
                        continue;
                    }
                    if (!isCheckJsonType || value == null) continue;
                    throw new OAuthException(itemName + " is not a Double");
                }
                if (Number.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Number) {
                        method.invoke(rsp, (Number)value);
                        continue;
                    }
                    if (!isCheckJsonType || value == null) continue;
                    throw new OAuthException(itemName + " is not a Number");
                }
                Object obj = reader.getObject(itemName, typeClass);
                if (obj == null) continue;
                method.invoke(rsp, obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rsp;
    }

    private static Field getField(Class<?> clazz, PropertyDescriptor pd) throws Exception {
        String key = clazz.getName() + "_" + pd.getName();
        Field field = fieldCache.get(key);
        if (field == null) {
            try {
                field = clazz.getDeclaredField(pd.getName());
                fieldCache.put(key, field);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        }
        return field;
    }

    static {
        baseProps.put(ErrorResponse.class.getName(), StringUtils.getClassProperties(ErrorResponse.class, false));
    }
}

