/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import net.dongliu.apk.parser.bean.ApkMeta;
import net.dongliu.apk.parser.bean.ApkSignStatus;
import net.dongliu.apk.parser.bean.CertificateMeta;
import net.dongliu.apk.parser.bean.DexClass;
import net.dongliu.apk.parser.bean.Icon;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.parser.ApkMetaTranslator;
import net.dongliu.apk.parser.parser.BinaryXmlParser;
import net.dongliu.apk.parser.parser.CertificateParser;
import net.dongliu.apk.parser.parser.CompositeXmlStreamer;
import net.dongliu.apk.parser.parser.DexParser;
import net.dongliu.apk.parser.parser.ResourceTableParser;
import net.dongliu.apk.parser.parser.XmlStreamer;
import net.dongliu.apk.parser.parser.XmlTranslator;
import net.dongliu.apk.parser.struct.resource.ResourceTable;

public abstract class AbstractApkFile
implements Closeable {
    private DexClass[] dexClasses;
    private ResourceTable resourceTable;
    private String manifestXml;
    private ApkMeta apkMeta;
    private Set<Locale> locales;
    private List<CertificateMeta> certificateMetaList;
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private Locale preferredLocale = DEFAULT_LOCALE;

    public String getManifestXml() throws IOException {
        if (this.manifestXml == null) {
            this.parseManifestXml();
        }
        return this.manifestXml;
    }

    public ApkMeta getApkMeta() throws IOException {
        if (this.apkMeta == null) {
            this.parseApkMeta();
        }
        return this.apkMeta;
    }

    public Set<Locale> getLocales() throws IOException {
        if (this.locales == null) {
            this.parseResourceTable();
        }
        return this.locales;
    }

    public List<CertificateMeta> getCertificateMetaList() throws IOException, CertificateException {
        if (this.certificateMetaList == null) {
            this.parseCertificate();
        }
        return this.certificateMetaList;
    }

    protected abstract byte[] getCertificateData() throws IOException;

    private void parseCertificate() throws IOException, CertificateException {
        byte[] data = this.getCertificateData();
        if (data == null) {
            throw new ParserException("ApkFile certificate not found");
        }
        CertificateParser parser = new CertificateParser(data);
        parser.parse();
        this.certificateMetaList = parser.getCertificateMetas();
    }

    private void parseApkMeta() throws IOException {
        if (this.manifestXml == null) {
            this.parseManifestXml();
        }
    }

    private void parseManifestXml() throws IOException {
        XmlTranslator xmlTranslator = new XmlTranslator();
        ApkMetaTranslator translator = new ApkMetaTranslator();
        CompositeXmlStreamer xmlStreamer = new CompositeXmlStreamer(xmlTranslator, translator);
        byte[] data = this.getFileData("AndroidManifest.xml");
        if (data == null) {
            throw new ParserException("Manifest file not found");
        }
        this.transBinaryXml(data, xmlStreamer);
        this.manifestXml = xmlTranslator.getXml();
        this.apkMeta = translator.getApkMeta();
    }

    public abstract byte[] getFileData(String var1) throws IOException;

    public String transBinaryXml(String path) throws IOException {
        byte[] data = this.getFileData(path);
        if (data == null) {
            return null;
        }
        if (this.resourceTable == null) {
            this.parseResourceTable();
        }
        XmlTranslator xmlTranslator = new XmlTranslator();
        this.transBinaryXml(data, xmlTranslator);
        return xmlTranslator.getXml();
    }

    private void transBinaryXml(byte[] data, XmlStreamer xmlStreamer) throws IOException {
        if (this.resourceTable == null) {
            this.parseResourceTable();
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        BinaryXmlParser binaryXmlParser = new BinaryXmlParser(buffer, this.resourceTable);
        binaryXmlParser.setLocale(this.preferredLocale);
        binaryXmlParser.setXmlStreamer(xmlStreamer);
        binaryXmlParser.parse();
    }

    public Icon getIconFile() throws IOException {
        ApkMeta apkMeta = this.getApkMeta();
        String iconPath = apkMeta.getIcon();
        if (iconPath == null) {
            return null;
        }
        return new Icon(iconPath, this.getFileData(iconPath));
    }

    public DexClass[] getDexClasses() throws IOException {
        if (this.dexClasses == null) {
            this.parseDexFiles();
        }
        return this.dexClasses;
    }

    private DexClass[] mergeDexClasses(DexClass[] first, DexClass[] second) {
        DexClass[] result = new DexClass[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private DexClass[] parseDexFile(String path) throws IOException {
        byte[] data = this.getFileData(path);
        if (data == null) {
            String msg = String.format("Dex file %s not found", path);
            throw new ParserException(msg);
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        DexParser dexParser = new DexParser(buffer);
        dexParser.parse();
        return dexParser.getDexClasses();
    }

    private void parseDexFiles() throws IOException {
        this.dexClasses = this.parseDexFile("classes.dex");
        for (int i = 2; i < 1000; ++i) {
            String path = String.format("classes%d.dex", i);
            try {
                DexClass[] classes = this.parseDexFile(path);
                this.dexClasses = this.mergeDexClasses(this.dexClasses, classes);
                continue;
            }
            catch (ParserException e) {
                break;
            }
        }
    }

    private void parseResourceTable() throws IOException {
        byte[] data = this.getFileData("resources.arsc");
        if (data == null) {
            this.resourceTable = new ResourceTable();
            this.locales = Collections.emptySet();
            return;
        }
        this.resourceTable = new ResourceTable();
        this.locales = Collections.emptySet();
        ByteBuffer buffer = ByteBuffer.wrap(data);
        ResourceTableParser resourceTableParser = new ResourceTableParser(buffer);
        resourceTableParser.parse();
        this.resourceTable = resourceTableParser.getResourceTable();
        this.locales = resourceTableParser.getLocales();
    }

    public abstract ApkSignStatus verifyApk() throws IOException;

    @Override
    public void close() throws IOException {
        this.certificateMetaList = null;
        this.resourceTable = null;
        this.certificateMetaList = null;
    }

    public Locale getPreferredLocale() {
        return this.preferredLocale;
    }

    public void setPreferredLocale(Locale preferredLocale) {
        if (!Objects.equals(this.preferredLocale, preferredLocale)) {
            this.preferredLocale = preferredLocale;
            this.manifestXml = null;
            this.apkMeta = null;
        }
    }
}

