/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.dongliu.apk.parser.AbstractApkFile;
import net.dongliu.apk.parser.bean.ApkSignStatus;
import net.dongliu.apk.parser.utils.Utils;

public class ApkFile
extends AbstractApkFile
implements Closeable {
    private final ZipFile zf;
    private File apkFile;

    public ApkFile(File apkFile) throws IOException {
        this.apkFile = apkFile;
        this.zf = new ZipFile(apkFile);
    }

    public ApkFile(String filePath) throws IOException {
        this(new File(filePath));
    }

    @Override
    protected byte[] getCertificateData() throws IOException {
        ZipEntry entry = null;
        Enumeration<? extends ZipEntry> enu = this.zf.entries();
        while (enu.hasMoreElements()) {
            ZipEntry ne = enu.nextElement();
            if (ne.isDirectory() || !ne.getName().toUpperCase().endsWith(".RSA") && !ne.getName().toUpperCase().endsWith(".DSA")) continue;
            entry = ne;
            break;
        }
        if (entry == null) {
            return null;
        }
        return Utils.toByteArray(this.zf.getInputStream(entry));
    }

    @Override
    public byte[] getFileData(String path) throws IOException {
        ZipEntry entry = this.zf.getEntry(path);
        if (entry == null) {
            return null;
        }
        InputStream inputStream = this.zf.getInputStream(entry);
        return Utils.toByteArray(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ApkSignStatus verifyApk() throws IOException {
        ZipEntry entry = this.zf.getEntry("META-INF/MANIFEST.MF");
        if (entry == null) {
            return ApkSignStatus.notSigned;
        }
        try (JarFile jarFile = new JarFile(this.apkFile);){
            Enumeration<JarEntry> entries = jarFile.entries();
            byte[] buffer = new byte[8192];
            block23: while (entries.hasMoreElements()) {
                Object object;
                JarEntry e = entries.nextElement();
                if (e.isDirectory()) continue;
                try {
                    InputStream in = jarFile.getInputStream(e);
                    object = null;
                    try {
                        while (true) {
                            int count;
                            if ((count = in.read(buffer, 0, buffer.length)) == -1) continue block23;
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (in == null) continue;
                        if (object != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (SecurityException se) {
                    object = ApkSignStatus.incorrect;
                    if (jarFile == null) return object;
                    if (var3_3 != null) {
                        try {
                            jarFile.close();
                            return object;
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                            return object;
                        }
                    }
                    jarFile.close();
                    return object;
                }
            }
            return ApkSignStatus.signed;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.zf.close();
    }
}

