/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.struct.ChunkHeader;
import net.dongliu.apk.parser.struct.StringPool;
import net.dongliu.apk.parser.struct.StringPoolHeader;
import net.dongliu.apk.parser.struct.resource.LibraryEntry;
import net.dongliu.apk.parser.struct.resource.LibraryHeader;
import net.dongliu.apk.parser.struct.resource.PackageHeader;
import net.dongliu.apk.parser.struct.resource.ResTableConfig;
import net.dongliu.apk.parser.struct.resource.ResourcePackage;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import net.dongliu.apk.parser.struct.resource.ResourceTableHeader;
import net.dongliu.apk.parser.struct.resource.Type;
import net.dongliu.apk.parser.struct.resource.TypeHeader;
import net.dongliu.apk.parser.struct.resource.TypeSpec;
import net.dongliu.apk.parser.struct.resource.TypeSpecHeader;
import net.dongliu.apk.parser.utils.Buffers;
import net.dongliu.apk.parser.utils.Pair;
import net.dongliu.apk.parser.utils.ParseUtils;

public class ResourceTableParser {
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private StringPool stringPool;
    private ByteBuffer buffer;
    private ResourceTable resourceTable;
    private Set<Locale> locales;

    public ResourceTableParser(ByteBuffer buffer) {
        this.buffer = buffer.duplicate();
        this.buffer.order(this.byteOrder);
        this.locales = new HashSet<Locale>();
    }

    public void parse() {
        ResourceTableHeader resourceTableHeader = (ResourceTableHeader)this.readChunkHeader();
        this.stringPool = ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader());
        this.resourceTable = new ResourceTable();
        this.resourceTable.setStringPool(this.stringPool);
        PackageHeader packageHeader = (PackageHeader)this.readChunkHeader();
        int i = 0;
        while ((long)i < resourceTableHeader.getPackageCount()) {
            Pair<ResourcePackage, PackageHeader> pair = this.readPackage(packageHeader);
            this.resourceTable.addPackage(pair.getLeft());
            packageHeader = pair.getRight();
            ++i;
        }
    }

    private Pair<ResourcePackage, PackageHeader> readPackage(PackageHeader packageHeader) {
        Pair<ResourcePackage, PackageHeader> pair = new Pair<ResourcePackage, PackageHeader>();
        ResourcePackage resourcePackage = new ResourcePackage(packageHeader);
        pair.setLeft(resourcePackage);
        long beginPos = this.buffer.position();
        if (packageHeader.getTypeStrings() > 0L) {
            this.buffer.position((int)(beginPos + packageHeader.getTypeStrings() - (long)packageHeader.getHeaderSize()));
            resourcePackage.setTypeStringPool(ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader()));
        }
        if (packageHeader.getKeyStrings() > 0L) {
            this.buffer.position((int)(beginPos + packageHeader.getKeyStrings() - (long)packageHeader.getHeaderSize()));
            resourcePackage.setKeyStringPool(ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader()));
        }
        block6: while (this.buffer.hasRemaining()) {
            ChunkHeader chunkHeader = this.readChunkHeader();
            long chunkBegin = this.buffer.position();
            switch (chunkHeader.getChunkType()) {
                case 514: {
                    TypeSpecHeader typeSpecHeader = (TypeSpecHeader)chunkHeader;
                    long[] entryFlags = new long[(int)typeSpecHeader.getEntryCount()];
                    int i = 0;
                    while ((long)i < typeSpecHeader.getEntryCount()) {
                        entryFlags[i] = Buffers.readUInt(this.buffer);
                        ++i;
                    }
                    TypeSpec typeSpec = new TypeSpec(typeSpecHeader);
                    typeSpec.setEntryFlags(entryFlags);
                    typeSpec.setName(resourcePackage.getTypeStringPool().get(typeSpecHeader.getId() - 1));
                    resourcePackage.addTypeSpec(typeSpec);
                    this.buffer.position((int)(chunkBegin + (long)typeSpecHeader.getBodySize()));
                    break;
                }
                case 513: {
                    TypeHeader typeHeader = (TypeHeader)chunkHeader;
                    long[] offsets = new long[(int)typeHeader.getEntryCount()];
                    int i = 0;
                    while ((long)i < typeHeader.getEntryCount()) {
                        offsets[i] = Buffers.readUInt(this.buffer);
                        ++i;
                    }
                    Type type = new Type(typeHeader);
                    type.setName(resourcePackage.getTypeStringPool().get(typeHeader.getId() - 1));
                    long entryPos = chunkBegin + typeHeader.getEntriesStart() - (long)typeHeader.getHeaderSize();
                    this.buffer.position((int)entryPos);
                    ByteBuffer b = this.buffer.slice();
                    b.order(this.byteOrder);
                    type.setBuffer(b);
                    type.setKeyStringPool(resourcePackage.getKeyStringPool());
                    type.setOffsets(offsets);
                    type.setStringPool(this.stringPool);
                    resourcePackage.addType(type);
                    this.locales.add(type.getLocale());
                    this.buffer.position((int)(chunkBegin + (long)typeHeader.getBodySize()));
                    break;
                }
                case 512: {
                    pair.setRight((PackageHeader)chunkHeader);
                    break block6;
                }
                case 515: {
                    LibraryHeader libraryHeader = (LibraryHeader)chunkHeader;
                    for (long i = 0L; i < libraryHeader.getCount(); ++i) {
                        int packageId = this.buffer.getInt();
                        String name = Buffers.readZeroTerminatedString(this.buffer, 128);
                        LibraryEntry libraryEntry = new LibraryEntry(packageId, name);
                    }
                    this.buffer.position((int)(chunkBegin + (long)chunkHeader.getBodySize()));
                    break;
                }
                default: {
                    throw new ParserException("unexpected chunk type: 0x" + chunkHeader.getChunkType());
                }
            }
        }
        return pair;
    }

    private ChunkHeader readChunkHeader() {
        long begin = this.buffer.position();
        int chunkType = Buffers.readUShort(this.buffer);
        int headerSize = Buffers.readUShort(this.buffer);
        long chunkSize = Buffers.readUInt(this.buffer);
        switch (chunkType) {
            case 2: {
                ResourceTableHeader resourceTableHeader = new ResourceTableHeader(chunkType, headerSize, chunkSize);
                resourceTableHeader.setPackageCount(Buffers.readUInt(this.buffer));
                this.buffer.position((int)(begin + (long)headerSize));
                return resourceTableHeader;
            }
            case 1: {
                StringPoolHeader stringPoolHeader = new StringPoolHeader(chunkType, headerSize, chunkSize);
                stringPoolHeader.setStringCount(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStyleCount(Buffers.readUInt(this.buffer));
                stringPoolHeader.setFlags(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStringsStart(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStylesStart(Buffers.readUInt(this.buffer));
                this.buffer.position((int)(begin + (long)headerSize));
                return stringPoolHeader;
            }
            case 512: {
                PackageHeader packageHeader = new PackageHeader(chunkType, headerSize, chunkSize);
                packageHeader.setId(Buffers.readUInt(this.buffer));
                packageHeader.setName(ParseUtils.readStringUTF16(this.buffer, 128));
                packageHeader.setTypeStrings(Buffers.readUInt(this.buffer));
                packageHeader.setLastPublicType(Buffers.readUInt(this.buffer));
                packageHeader.setKeyStrings(Buffers.readUInt(this.buffer));
                packageHeader.setLastPublicKey(Buffers.readUInt(this.buffer));
                this.buffer.position((int)(begin + (long)headerSize));
                return packageHeader;
            }
            case 514: {
                TypeSpecHeader typeSpecHeader = new TypeSpecHeader(chunkType, headerSize, chunkSize);
                typeSpecHeader.setId(Buffers.readUByte(this.buffer));
                typeSpecHeader.setRes0(Buffers.readUByte(this.buffer));
                typeSpecHeader.setRes1(Buffers.readUShort(this.buffer));
                typeSpecHeader.setEntryCount(Buffers.readUInt(this.buffer));
                this.buffer.position((int)(begin + (long)headerSize));
                return typeSpecHeader;
            }
            case 513: {
                TypeHeader typeHeader = new TypeHeader(chunkType, headerSize, chunkSize);
                typeHeader.setId(Buffers.readUByte(this.buffer));
                typeHeader.setRes0(Buffers.readUByte(this.buffer));
                typeHeader.setRes1(Buffers.readUShort(this.buffer));
                typeHeader.setEntryCount(Buffers.readUInt(this.buffer));
                typeHeader.setEntriesStart(Buffers.readUInt(this.buffer));
                typeHeader.setConfig(this.readResTableConfig());
                this.buffer.position((int)(begin + (long)headerSize));
                return typeHeader;
            }
            case 515: {
                LibraryHeader libraryHeader = new LibraryHeader(chunkType, headerSize, chunkSize);
                libraryHeader.setCount(Buffers.readUInt(this.buffer));
                this.buffer.position((int)(begin + (long)headerSize));
                return libraryHeader;
            }
        }
        throw new ParserException("Unexpected chunk Type: 0x" + Integer.toHexString(chunkType));
    }

    private ResTableConfig readResTableConfig() {
        long beginPos = this.buffer.position();
        ResTableConfig config = new ResTableConfig();
        long size = Buffers.readUInt(this.buffer);
        Buffers.skip(this.buffer, 4);
        config.setLanguage(new String(Buffers.readBytes(this.buffer, 2)).replace("\u0000", ""));
        config.setCountry(new String(Buffers.readBytes(this.buffer, 2)).replace("\u0000", ""));
        long endPos = this.buffer.position();
        Buffers.skip(this.buffer, (int)(size - (endPos - beginPos)));
        return config;
    }

    public ResourceTable getResourceTable() {
        return this.resourceTable;
    }

    public Set<Locale> getLocales() {
        return this.locales;
    }
}

