/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import javax.annotation.Nullable;
import net.dongliu.commons.collection.Pair;
import net.dongliu.requests.Cookie;

class CookieUtils {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    CookieUtils() {
    }

    static String effectivePath(String path) {
        int idx = path.lastIndexOf(47);
        if (idx >= 0) {
            return path.substring(0, idx + 1);
        }
        return "/";
    }

    static String escape(String value) {
        int count = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != ' ' && c != ';' && c != ',') continue;
            ++count;
        }
        if (count == 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value.length() + count * 2);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == ' ' || c == ';' || c == ',') {
                sb.append('%').append(hexChars[c >> 4]).append(hexChars[c & 0xF]);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static boolean isSubDomain(String domain, String subDomain) {
        if (domain.length() - 1 == subDomain.length()) {
            return domain.endsWith(subDomain);
        }
        return domain.length() < subDomain.length() && subDomain.endsWith(domain);
    }

    static Cookie parseCookieHeader(String originDomain, String originPath, String headerValue) {
        String[] items = headerValue.split("; ");
        Map.Entry<String, String> nameValue = CookieUtils.parseCookieNameValue(items[0]);
        String domain = null;
        String path = null;
        Instant expiry = null;
        boolean secure = false;
        block20: for (int i = 1; i < items.length - 1; ++i) {
            Map.Entry<String, String> attribute = CookieUtils.parseCookieAttribute(items[i]);
            switch (attribute.getKey().toLowerCase()) {
                case "domain": {
                    domain = CookieUtils.parseDomain(originDomain, attribute);
                    continue block20;
                }
                case "path": {
                    path = attribute.getValue().endsWith("/") ? attribute.getValue() : attribute.getValue() + "/";
                    continue block20;
                }
                case "expires": {
                    try {
                        expiry = DateTimeFormatter.RFC_1123_DATE_TIME.parse((CharSequence)attribute.getValue(), Instant::from);
                    }
                    catch (DateTimeParseException dateTimeParseException) {}
                    continue block20;
                }
                case "max-age": {
                    try {
                        int seconds = Integer.parseInt(attribute.getValue());
                        if (seconds < 0) continue block20;
                        expiry = Instant.now().plusSeconds(seconds);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block20;
                }
                case "secure": {
                    secure = true;
                    continue block20;
                }
                case "httponly": {
                    continue block20;
                }
            }
        }
        return new Cookie(domain == null ? originDomain : domain, path == null ? originPath : path, nameValue.getKey(), nameValue.getValue(), expiry, secure);
    }

    private static Map.Entry<String, String> parseCookieNameValue(String str) {
        int idx = str.indexOf("=");
        if (idx < 0) {
            return Pair.of((Object)"", (Object)str);
        }
        return Pair.of((Object)str.substring(0, idx), (Object)str.substring(idx + 1));
    }

    private static Map.Entry<String, String> parseCookieAttribute(String str) {
        int idx = str.indexOf("=");
        if (idx < 0) {
            return Pair.of((Object)str, (Object)"");
        }
        return Pair.of((Object)str.substring(0, idx), (Object)str.substring(idx + 1));
    }

    @Nullable
    private static String parseDomain(String currentDomain, Map.Entry<String, String> pair) {
        String domain = pair.getValue();
        if (!domain.startsWith(".")) {
            domain = "." + domain;
        }
        if (!CookieUtils.isSubDomain(domain, currentDomain)) {
            domain = null;
        }
        return domain;
    }
}

