/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.dongliu.requests.BasicAuth;
import net.dongliu.requests.CertificateInfo;
import net.dongliu.requests.RequestBuilder;
import net.dongliu.requests.Session;
import net.dongliu.requests.URIEncoder;
import net.dongliu.requests.body.RequestBody;

public class HttpRequest {
    static final int DEFAULT_TIMEOUT = 10000;
    private final String method;
    private final Collection<? extends Map.Entry<String, ?>> headers;
    private final Collection<? extends Map.Entry<String, ?>> cookies;
    private final String userAgent;
    private final Charset charset;
    private final RequestBody<?> body;
    private final int socksTimeout;
    private final int connectTimeout;
    private final Proxy proxy;
    private final boolean followRedirect;
    private final boolean compress;
    private final boolean verify;
    private final List<CertificateInfo> certs;
    private final BasicAuth basicAuth;
    @Nonnull
    private final Session session;
    private final URL url;
    private final boolean keepAlive;

    HttpRequest(RequestBuilder builder) {
        this.method = builder.method;
        this.headers = builder.headers;
        this.cookies = builder.cookies;
        this.userAgent = builder.userAgent;
        this.charset = builder.requestCharset;
        this.body = builder.body;
        this.socksTimeout = builder.socksTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.proxy = builder.proxy;
        this.followRedirect = builder.followRedirect;
        this.compress = builder.compress;
        this.verify = builder.verify;
        this.certs = builder.certs;
        this.basicAuth = builder.basicAuth;
        this.session = builder.session;
        this.keepAlive = builder.keepAlive;
        this.url = HttpRequest.joinUrl(builder.url, builder.params, this.charset);
    }

    private static URL joinUrl(String url, Collection<? extends Map.Entry<String, ?>> params, Charset charset) {
        String fullUrl = params.isEmpty() ? url : url + "?" + URIEncoder.encodeQueries(params, charset);
        try {
            return new URL(fullUrl);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public Collection<? extends Map.Entry<String, ?>> getHeaders() {
        return this.headers;
    }

    public Collection<? extends Map.Entry<String, ?>> getCookies() {
        return this.cookies;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public RequestBody<?> getBody() {
        return this.body;
    }

    public int getSocksTimeout() {
        return this.socksTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public boolean isVerify() {
        return this.verify;
    }

    public List<CertificateInfo> getCerts() {
        return this.certs;
    }

    public BasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    @Nonnull
    public Session getSession() {
        return this.session;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }
}

