/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Objects;
import net.dongliu.requests.BasicAuth;

public class Proxies {
    public static Proxy httpProxy(String host, int port) {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(Objects.requireNonNull(host), port));
    }

    public static Proxy httpProxy(String host, int port, String user, String password) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(password);
        return new AuthenticationHttpProxy(new InetSocketAddress(Objects.requireNonNull(host), port), new BasicAuth(user, password));
    }

    public static Proxy socksProxy(String host, int port) {
        return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(Objects.requireNonNull(host), port));
    }

    static class AuthenticationHttpProxy
    extends Proxy {
        private final BasicAuth basicAuth;

        private AuthenticationHttpProxy(SocketAddress address, BasicAuth basicAuth) {
            super(Proxy.Type.HTTP, address);
            this.basicAuth = basicAuth;
        }

        BasicAuth getBasicAuth() {
            return this.basicAuth;
        }
    }
}

