/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dongliu.commons.io.Closeables;
import net.dongliu.commons.io.InputOutputs;
import net.dongliu.requests.Cookie;
import net.dongliu.requests.ResponseHeaders;
import net.dongliu.requests.json.JsonLookup;
import net.dongliu.requests.json.TypeInfer;

public class RawResponse
implements AutoCloseable {
    private final int statusCode;
    private final Set<Cookie> cookies;
    private final ResponseHeaders headers;
    private final InputStream input;
    private final HttpURLConnection conn;

    RawResponse(int statusCode, ResponseHeaders headers, Set<Cookie> cookies, InputStream input, HttpURLConnection conn) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.cookies = Collections.unmodifiableSet(cookies);
        this.input = input;
        this.conn = conn;
    }

    @Override
    public void close() {
        Closeables.closeQuietly((AutoCloseable)this.input);
        this.conn.disconnect();
    }

    public String readToText() {
        Charset charset = this.getCharsetFromHeaders(StandardCharsets.UTF_8);
        return this.readToText(charset);
    }

    /*
     * Exception decompiling
     */
    public String readToText(Charset charset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] readToBytes() {
        try {
            byte[] byArray = InputOutputs.readAll((InputStream)this.input);
            return byArray;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readToJson(Type type, Charset charset) {
        try {
            Object t = JsonLookup.getInstance().lookup().unmarshal((Reader)new InputStreamReader(this.input, charset), type);
            return t;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readToJson(Type type) {
        try {
            Charset charset = this.getCharsetFromHeaders(StandardCharsets.UTF_8);
            T t = this.readToJson(type, charset);
            return t;
        }
        finally {
            this.close();
        }
    }

    public <T> T readToJson(TypeInfer<T> typeInfer, Charset charset) {
        return this.readToJson(typeInfer.getType(), charset);
    }

    public <T> T readToJson(TypeInfer<T> typeInfer) {
        return this.readToJson(typeInfer.getType());
    }

    public <T> T readToJson(Class<T> cls, Charset charset) {
        return this.readToJson((Type)cls, charset);
    }

    public <T> T readToJson(Class<T> cls) {
        return this.readToJson((Type)cls);
    }

    public void writeToFile(File path) {
        try (FileOutputStream os = new FileOutputStream(path);){
            InputOutputs.copy((InputStream)this.input, (OutputStream)os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.close();
        }
    }

    public void writeToFile(Path path) {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            InputOutputs.copy((InputStream)this.input, (OutputStream)os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.close();
        }
    }

    public void writeToFile(String path) {
        try (FileOutputStream os = new FileOutputStream(path);){
            InputOutputs.copy((InputStream)this.input, (OutputStream)os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.close();
        }
    }

    public void writeTo(OutputStream out) {
        try {
            InputOutputs.copy((InputStream)this.input, (OutputStream)out);
        }
        finally {
            this.close();
        }
    }

    public void discardBody() {
        try {
            InputOutputs.skipAll((InputStream)this.input);
        }
        finally {
            this.close();
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public InputStream getInput() {
        return this.input;
    }

    @Nullable
    public String getFirstHeader(String name) {
        return this.headers.getFirstHeader(name);
    }

    @Nonnull
    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers.getHeaders();
    }

    @Nonnull
    public List<String> getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    public Collection<Cookie> getCookies() {
        return this.cookies;
    }

    private Charset getCharsetFromHeaders(Charset defaultCharset) {
        String[] items;
        String contentType = this.getFirstHeader("Content-Type");
        if (contentType == null) {
            return defaultCharset;
        }
        for (String item : items = contentType.split("; ")) {
            String key;
            int idx = item.indexOf(61);
            if (idx < 0 || !(key = item.substring(0, idx).trim()).equalsIgnoreCase("charset")) continue;
            return Charset.forName(item.substring(idx + 1).trim());
        }
        return defaultCharset;
    }
}

