/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.body;

import java.io.File;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import net.dongliu.requests.body.MultiPartRequestBody;
import net.dongliu.requests.body.RequestBody;

public class Part<T> {
    private final String name;
    @Nullable
    private final String fileName;
    private final RequestBody<T> requestBody;

    public Part(String name, @Nullable String fileName, RequestBody<T> requestBody) {
        this.name = Objects.requireNonNull(name);
        this.fileName = fileName;
        Objects.requireNonNull(requestBody);
        if (requestBody instanceof MultiPartRequestBody) {
            throw new IllegalArgumentException("Could not use MultiPartRequest self as a part");
        }
        this.requestBody = requestBody;
    }

    public Part contentType(String contentType) {
        this.requestBody.setContentType(contentType);
        return this;
    }

    public static Part<File> file(String name, File file) {
        return new Part<File>(name, file.getName(), RequestBody.file(file));
    }

    public static Part<InputStream> file(String name, String fileName, InputStream in) {
        return new Part<InputStream>(name, fileName, RequestBody.inputStream(in));
    }

    public static Part<byte[]> file(String name, String fileName, byte[] bytes) {
        return new Part<byte[]>(name, fileName, RequestBody.bytes(bytes));
    }

    public static Part<String> text(String name, String value) {
        return new Part<String>(name, null, RequestBody.text(value));
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    public RequestBody<T> getRequestBody() {
        return this.requestBody;
    }
}

