/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.json;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.dongliu.requests.json.GsonProvider;
import net.dongliu.requests.json.JacksonProvider;
import net.dongliu.requests.json.JsonProvider;
import net.dongliu.requests.json.ProviderNotFoundException;

@ThreadSafe
public class JsonLookup {
    private static final Logger logger = Logger.getLogger(JsonLookup.class.getName());
    private static JsonLookup instance = new JsonLookup();
    @Nullable
    private volatile JsonProvider registeredJsonProvider;
    private final JsonProvider lookedJsonProvider = this.lookupInClasspath();

    private JsonLookup() {
    }

    public static JsonLookup getInstance() {
        return instance;
    }

    public void register(JsonProvider jsonProvider) {
        this.registeredJsonProvider = Objects.requireNonNull(jsonProvider);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Set json provider to " + jsonProvider.getClass().getName());
        }
    }

    boolean hasGson() {
        try {
            Class.forName("com.google.gson.Gson");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    JsonProvider gsonProvider() {
        return new GsonProvider();
    }

    boolean hasJackson() {
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    JsonProvider jacksonProvider() {
        return new JacksonProvider();
    }

    @Nonnull
    public JsonProvider lookup() {
        JsonProvider jsonProvider = this.registeredJsonProvider;
        if (jsonProvider == null) {
            jsonProvider = this.lookedJsonProvider;
        }
        if (jsonProvider != null) {
            return jsonProvider;
        }
        throw new ProviderNotFoundException("Json Provider not found");
    }

    @Nullable
    private JsonProvider lookupInClasspath() {
        if (this.hasJackson()) {
            logger.fine("Use default jackson provider to deal with json");
            this.registeredJsonProvider = this.jacksonProvider();
            return this.registeredJsonProvider;
        }
        if (this.hasGson()) {
            logger.fine("Use default gson provider to deal with json");
            this.registeredJsonProvider = this.gsonProvider();
            return this.registeredJsonProvider;
        }
        return null;
    }
}

