/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dongliu.requests.json.TypeInfer;

public interface JsonProvider {
    public void marshal(Writer var1, @Nullable Object var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    default public String marshal(Object value) {
        try (StringWriter sw = new StringWriter();){
            this.marshal(sw, value);
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    public <T> T unmarshal(Reader var1, Type var2);

    @Nullable
    default public <T> T unmarshal(Reader reader, Class<T> cls) {
        return this.unmarshal(reader, (Type)cls);
    }

    @Nullable
    default public <T> T unmarshal(Reader reader, TypeInfer<T> typeInfer) {
        return this.unmarshal(reader, typeInfer.getType());
    }

    @Nullable
    default public <T> T unmarshal(String str, Type type) {
        try (StringReader reader = new StringReader(str);){
            T t = this.unmarshal((Reader)reader, type);
            return t;
        }
    }

    @Nullable
    default public <T> T unmarshal(String str, Class<T> cls) {
        return this.unmarshal(str, (Type)cls);
    }

    @Nullable
    default public <T> T unmarshal(String str, TypeInfer<T> typeInfer) {
        return this.unmarshal(str, typeInfer.getType());
    }
}

