/*
 * Decompiled with CFR 0.152.
 */
package net.fastposter.client.autoconfigure;

import net.fastposter.client.FastposterClient;
import net.fastposter.client.autoconfigure.FastposterClientProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"net.fastposter.client"})
@EnableConfigurationProperties(value={FastposterClientProperties.class})
public class FastposterClientAutoConfiguration {
    private final FastposterClientProperties properties;

    @Bean
    @ConditionalOnProperty(value={"fastposter.token"})
    FastposterClient fastposterClient() {
        return FastposterClient.builder().endpoint(this.properties.getEndpoint()).token(this.properties.getToken()).debug(this.properties.isDebug()).trace(this.properties.isTrace()).build();
    }

    public FastposterClientAutoConfiguration(FastposterClientProperties properties) {
        this.properties = properties;
    }
}

