/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.api.arbitraries;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.Year;
import java.util.Calendar;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.4.0")
public interface CalendarArbitrary
extends Arbitrary<Calendar> {
    default public CalendarArbitrary between(Calendar min, Calendar max) {
        if (min.after(max)) {
            return this.atTheEarliest(max).atTheLatest(min);
        }
        return this.atTheEarliest(min).atTheLatest(max);
    }

    public CalendarArbitrary atTheEarliest(Calendar var1);

    public CalendarArbitrary atTheLatest(Calendar var1);

    public CalendarArbitrary yearBetween(Year var1, Year var2);

    default public CalendarArbitrary yearBetween(int min, int max) {
        return this.yearBetween(Year.of(min), Year.of(max));
    }

    public CalendarArbitrary monthBetween(Month var1, Month var2);

    default public CalendarArbitrary monthBetween(int min, int max) {
        return this.monthBetween(Month.of(min), Month.of(max));
    }

    public CalendarArbitrary onlyMonths(Month ... var1);

    public CalendarArbitrary dayOfMonthBetween(int var1, int var2);

    public CalendarArbitrary onlyDaysOfWeek(DayOfWeek ... var1);
}

