/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.DateArbitrary;
import net.jqwik.time.api.arbitraries.InstantArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.MonthDayArbitrary;
import net.jqwik.time.api.arbitraries.OffsetDateTimeArbitrary;
import net.jqwik.time.api.constraints.DayOfMonthRange;
import net.jqwik.time.internal.properties.arbitraries.DefaultInstantArbitrary;

public class DayOfMonthRangeConfigurator {
    private static boolean filter(int dayOfMonth, int min, int max) {
        return dayOfMonth >= min && dayOfMonth <= max;
    }

    private static boolean filter(LocalDateTime dateTime, int min, int max) {
        return DayOfMonthRangeConfigurator.filter(dateTime.getDayOfMonth(), min, max);
    }

    private static boolean filter(Instant instant, int min, int max) {
        if (LocalDateTime.MIN.toInstant(ZoneOffset.UTC).isAfter(instant) || LocalDateTime.MAX.toInstant(ZoneOffset.UTC).isBefore(instant)) {
            return false;
        }
        return DayOfMonthRangeConfigurator.filter(DefaultInstantArbitrary.instantToLocalDateTime(instant).getDayOfMonth(), min, max);
    }

    private static boolean filter(OffsetDateTime dateTime, int min, int max) {
        return DayOfMonthRangeConfigurator.filter(dateTime.getDayOfMonth(), min, max);
    }

    private static boolean filter(LocalDate date, int min, int max) {
        return DayOfMonthRangeConfigurator.filter(date.getDayOfMonth(), min, max);
    }

    private static boolean filter(Calendar date, int min, int max) {
        return DayOfMonthRangeConfigurator.filter(date.get(5), min, max);
    }

    private static boolean filter(Date date, int min, int max) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DayOfMonthRangeConfigurator.filter(calendar, min, max);
    }

    private static boolean filter(MonthDay monthDay, int min, int max) {
        return DayOfMonthRangeConfigurator.filter(monthDay.getDayOfMonth(), min, max);
    }

    public static class ForInteger
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Integer.class);
        }

        public Arbitrary<Integer> configure(Arbitrary<Integer> arbitrary, DayOfMonthRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof IntegerArbitrary) {
                IntegerArbitrary dayOfMonthsArbitrary = (IntegerArbitrary)arbitrary;
                return dayOfMonthsArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> DayOfMonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForMonthDay
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(MonthDay.class);
        }

        public Arbitrary<MonthDay> configure(Arbitrary<MonthDay> arbitrary, DayOfMonthRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof MonthDayArbitrary) {
                MonthDayArbitrary monthDayArbitrary = (MonthDayArbitrary)arbitrary;
                return monthDayArbitrary.dayOfMonthBetween(min, max);
            }
            return arbitrary.filter(v -> DayOfMonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Date.class);
        }

        public Arbitrary<Date> configure(Arbitrary<Date> arbitrary, DayOfMonthRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof DateArbitrary) {
                DateArbitrary dateArbitrary = (DateArbitrary)arbitrary;
                return dateArbitrary.dayOfMonthBetween(min, max);
            }
            return arbitrary.filter(v -> DayOfMonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForCalendar
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Calendar.class);
        }

        public Arbitrary<Calendar> configure(Arbitrary<Calendar> arbitrary, DayOfMonthRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof CalendarArbitrary) {
                CalendarArbitrary calendarArbitrary = (CalendarArbitrary)arbitrary;
                return calendarArbitrary.dayOfMonthBetween(min, max);
            }
            return arbitrary.filter(v -> DayOfMonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDate.class);
        }

        public Arbitrary<LocalDate> configure(Arbitrary<LocalDate> arbitrary, DayOfMonthRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof LocalDateArbitrary) {
                LocalDateArbitrary localDateArbitrary = (LocalDateArbitrary)arbitrary;
                return localDateArbitrary.dayOfMonthBetween(min, max);
            }
            return arbitrary.filter(v -> DayOfMonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForOffsetDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetDateTime.class);
        }

        public Arbitrary<OffsetDateTime> configure(Arbitrary<OffsetDateTime> arbitrary, DayOfMonthRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof OffsetDateTimeArbitrary) {
                OffsetDateTimeArbitrary offsetDateTimeArbitrary = (OffsetDateTimeArbitrary)arbitrary;
                return offsetDateTimeArbitrary.dayOfMonthBetween(min, max);
            }
            return arbitrary.filter(v -> DayOfMonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForInstant
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Instant.class);
        }

        public Arbitrary<Instant> configure(Arbitrary<Instant> arbitrary, DayOfMonthRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof InstantArbitrary) {
                InstantArbitrary instantArbitrary = (InstantArbitrary)arbitrary;
                return instantArbitrary.dayOfMonthBetween(min, max);
            }
            return arbitrary.filter(v -> DayOfMonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDateTime.class);
        }

        public Arbitrary<LocalDateTime> configure(Arbitrary<LocalDateTime> arbitrary, DayOfMonthRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof LocalDateTimeArbitrary) {
                LocalDateTimeArbitrary localDateTimeArbitrary = (LocalDateTimeArbitrary)arbitrary;
                return localDateTimeArbitrary.dayOfMonthBetween(min, max);
            }
            return arbitrary.filter(v -> DayOfMonthRangeConfigurator.filter(v, min, max));
        }
    }
}

