/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.InstantArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetTimeArbitrary;
import net.jqwik.time.api.constraints.MinuteRange;
import net.jqwik.time.internal.properties.arbitraries.DefaultInstantArbitrary;

public class MinuteRangeConfigurator {
    private static boolean filter(LocalTime time, int min, int max) {
        return time.getMinute() >= min && time.getMinute() <= max;
    }

    private static boolean filter(LocalDateTime dateTime, int min, int max) {
        return MinuteRangeConfigurator.filter(dateTime.toLocalTime(), min, max);
    }

    private static boolean filter(Instant instant, int min, int max) {
        if (LocalDateTime.MIN.toInstant(ZoneOffset.UTC).isAfter(instant) || LocalDateTime.MAX.toInstant(ZoneOffset.UTC).isBefore(instant)) {
            return false;
        }
        return MinuteRangeConfigurator.filter(DefaultInstantArbitrary.instantToLocalDateTime(instant).toLocalTime(), min, max);
    }

    private static boolean filter(OffsetDateTime dateTime, int min, int max) {
        return MinuteRangeConfigurator.filter(dateTime.toLocalTime(), min, max);
    }

    private static boolean filter(OffsetTime offsetTime, int min, int max) {
        return MinuteRangeConfigurator.filter(offsetTime.toLocalTime(), min, max);
    }

    public static class ForOffsetTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetTime.class);
        }

        public Arbitrary<OffsetTime> configure(Arbitrary<OffsetTime> arbitrary, MinuteRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof OffsetTimeArbitrary) {
                OffsetTimeArbitrary offsetTimeArbitrary = (OffsetTimeArbitrary)arbitrary;
                return offsetTimeArbitrary.minuteBetween(min, max);
            }
            return arbitrary.filter(v -> MinuteRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalTime.class);
        }

        public Arbitrary<LocalTime> configure(Arbitrary<LocalTime> arbitrary, MinuteRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof LocalTimeArbitrary) {
                LocalTimeArbitrary localTimeArbitrary = (LocalTimeArbitrary)arbitrary;
                return localTimeArbitrary.minuteBetween(min, max);
            }
            return arbitrary.filter(v -> MinuteRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForOffsetDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetDateTime.class);
        }

        public Arbitrary<OffsetDateTime> configure(Arbitrary<OffsetDateTime> arbitrary, MinuteRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof OffsetDateTimeArbitrary) {
                OffsetDateTimeArbitrary offsetDateTimeArbitrary = (OffsetDateTimeArbitrary)arbitrary;
                return offsetDateTimeArbitrary.minuteBetween(min, max);
            }
            return arbitrary.filter(v -> MinuteRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForInstant
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Instant.class);
        }

        public Arbitrary<Instant> configure(Arbitrary<Instant> arbitrary, MinuteRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof InstantArbitrary) {
                InstantArbitrary instantArbitrary = (InstantArbitrary)arbitrary;
                return instantArbitrary.minuteBetween(min, max);
            }
            return arbitrary.filter(v -> MinuteRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDateTime.class);
        }

        public Arbitrary<LocalDateTime> configure(Arbitrary<LocalDateTime> arbitrary, MinuteRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof LocalDateTimeArbitrary) {
                LocalDateTimeArbitrary localDateTimeArbitrary = (LocalDateTimeArbitrary)arbitrary;
                return localDateTimeArbitrary.minuteBetween(min, max);
            }
            return arbitrary.filter(v -> MinuteRangeConfigurator.filter(v, min, max));
        }
    }
}

