package osmo.tester.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotated method is executed before each the specified (or any) test step.
 * <p>
 * 
 * If no name is given, association of "all" is assumed similar to guards.
 * 
 * The annotated method must have no parameters.
 *
 * @author Teemu Kanstren
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Pre {
  /** @return The set of test steps (or groups) this should be associated with. */
  String[] value() default Guard.DEFAULT;
}
