/*
 * Decompiled with CFR 0.152.
 */
package osmo.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class Randomizer {
    private Random random = new Random();
    private long seed = System.currentTimeMillis();

    public Randomizer(long seed) {
        this.setSeed(seed);
    }

    public Randomizer() {
        this.setSeed(this.seed);
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.random = new Random(seed);
        for (int i = 0; i < 3; ++i) {
            this.random.nextDouble();
        }
    }

    public int nextInt() {
        return this.random.nextInt();
    }

    public int nextInt(int min, int max) {
        long ldiff = (long)max - (long)min + 1L;
        if (ldiff > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Only integers in range up to 2147483647 supported. Given was " + ldiff + ".");
        }
        int diff = (int)ldiff;
        int rnd = this.random.nextInt(diff);
        return rnd += min;
    }

    public float nextFloat() {
        return this.random.nextFloat();
    }

    public float nextFloat(float min, float max) {
        float diff = max - min;
        float rnd = this.random.nextFloat() * diff;
        return rnd += min;
    }

    public long nextLong() {
        return this.random.nextLong();
    }

    public long nextLong(long min, long max) {
        long diff = max - min + 1L;
        return min + (long)(this.random.nextDouble() * (double)diff);
    }

    public byte nextByte() {
        return (byte)this.nextInt(-128, 127);
    }

    public byte nextByte(byte min, byte max) {
        return (byte)this.nextInt(min, max);
    }

    public char nextChar() {
        return (char)this.nextInt(0, 65535);
    }

    public char nextChar(char min, char max) {
        return (char)this.nextInt(min, max);
    }

    public boolean nextBoolean() {
        return this.nextDouble() >= 0.5;
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public double nextDouble(double min, double max) {
        double diff = max - min;
        double rnd = this.random.nextDouble();
        rnd *= diff;
        return rnd += min;
    }

    public int rawWeightedRandomFrom(List<Integer> weights) {
        ArrayList<Integer> totals = new ArrayList<Integer>();
        int total = 0;
        for (Integer weight : weights) {
            if (weight <= 0) {
                throw new IllegalArgumentException("Weight must be > 0. Was " + weight + ".");
            }
            totals.add(total += weight.intValue());
        }
        return this.sumWeightedRandomFrom(totals);
    }

    public int sumWeightedRandomFrom(List<Integer> summedTotals) {
        int total = summedTotals.get(summedTotals.size() - 1);
        int target = this.nextInt(1, total);
        int choice = Collections.binarySearch(summedTotals, target);
        if (choice < 0) {
            choice *= -1;
            --choice;
        }
        return choice;
    }

    public int oneOf(int[] array) {
        return array[this.nextInt(0, array.length - 1)];
    }

    public <T> T oneOf(T[] array) {
        return array[this.nextInt(0, array.length - 1)];
    }

    public <T> T oneOf(Collection<T> array) {
        ArrayList<T> list = new ArrayList<T>(array);
        int index = this.nextInt(0, array.size() - 1);
        return (T)list.get(index);
    }

    public <T extends Number> T minOf(Collection<T> array) {
        Number smallest = null;
        for (Number t : array) {
            if (smallest != null && !(t.doubleValue() < smallest.doubleValue())) continue;
            smallest = t;
        }
        return (T)smallest;
    }
}

