/*
 * Decompiled with CFR 0.152.
 */
package osmo.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import osmo.common.Randomizer;

public class TestUtils {
    private static Randomizer random = new Randomizer();
    public static String ln = System.getProperty("line.separator");
    private static OutputStream out = null;
    private static PrintStream sout = null;

    public static Randomizer getRandom() {
        return random;
    }

    public static void setRandom(Randomizer random) {
        TestUtils.random = random;
    }

    public static void setSeed(long seed) {
        random.setSeed(seed);
    }

    public static int cInt() {
        return random.nextInt();
    }

    public static int cInt(int min, int max) {
        return random.nextInt(min, max);
    }

    public static float cFloat() {
        return random.nextFloat();
    }

    public static float cFloat(float min, float max) {
        return random.nextFloat(min, max);
    }

    public static long cLong() {
        return random.nextLong();
    }

    public static long cLong(long min, long max) {
        return random.nextLong(min, max);
    }

    public static byte cByte() {
        return random.nextByte();
    }

    public static byte cByte(byte min, byte max) {
        return random.nextByte(min, max);
    }

    public static char cChar() {
        return random.nextChar();
    }

    public static char cChar(char min, char max) {
        return random.nextChar(min, max);
    }

    public static double cDouble() {
        return random.nextDouble();
    }

    public static double cDouble(double min, double max) {
        return random.nextDouble(min, max);
    }

    public static int rawWeightedRandomFrom(List<Integer> weights) {
        return random.rawWeightedRandomFrom(weights);
    }

    public static int sumWeightedRandomFrom(List<Integer> summedTotals) {
        return random.sumWeightedRandomFrom(summedTotals);
    }

    public static int oneOf(int[] array) {
        return random.oneOf(array);
    }

    public static <T> T oneOf(T[] array) {
        return random.oneOf(array);
    }

    public static <T> T oneOf(Collection<T> array) {
        return random.oneOf(array);
    }

    public static <T extends Number> T minOf(Collection<T> array) {
        return random.minOf(array);
    }

    public static String getThreadInfo() {
        ThreadMXBean tb = ManagementFactory.getThreadMXBean();
        long[] ids = tb.getAllThreadIds();
        ThreadInfo[] infos = tb.getThreadInfo(ids, 5);
        StringBuilder builder = new StringBuilder("Information for available threads:" + ln);
        for (ThreadInfo info : infos) {
            StackTraceElement[] trace;
            builder.append("Thread").append(ln);
            builder.append("-name=").append(info.getThreadName()).append(ln);
            builder.append("-state=").append((Object)info.getThreadState()).append(ln);
            builder.append("-stacktrace (5 elements):").append(ln);
            for (StackTraceElement line : trace = info.getStackTrace()) {
                builder.append("--").append(line).append(ln);
            }
        }
        return builder.toString();
    }

    public static String getResource(Class c, String name) {
        InputStream is = c.getResourceAsStream(name);
        return TestUtils.getResource(is);
    }

    public static String getResource(InputStream in) {
        StringBuilder text = new StringBuilder();
        try (Scanner scanner = new Scanner(in, "UTF-8");){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                text.append(line);
                if (!scanner.hasNextLine()) continue;
                text.append("\n");
            }
        }
        return text.toString();
    }

    public static String unifyLineSeparators(String toUnify, String ls) {
        char[] chars = toUnify.toCharArray();
        StringBuilder sb = new StringBuilder(toUnify.length());
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\n': {
                    sb.append(ls);
                    continue block4;
                }
                case '\r': {
                    sb.append(ls);
                    if (chars.length < i || chars[i + 1] != '\n') continue block4;
                    ++i;
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String formatXml(String xml) throws TransformerException {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(String text, String fileName) {
        File file = new File(fileName);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(text.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to file:" + fileName, e);
        }
    }

    public static List<String> listFiles(String dir, String type, boolean fullPath) {
        File folder = new File(dir);
        if (!folder.exists()) {
            throw new IllegalArgumentException("Given dir does not exist:" + dir);
        }
        File[] directoryList = folder.listFiles();
        ArrayList<String> files = new ArrayList<String>();
        for (File file : directoryList) {
            if (file.isFile()) {
                String name = file.getName();
                if (!name.endsWith(type)) continue;
                if (fullPath) {
                    files.add(file.getAbsolutePath());
                    continue;
                }
                files.add(name);
                continue;
            }
            if (!file.isDirectory()) continue;
        }
        return files;
    }

    public static void recursiveDelete(String path) {
        TestUtils.recursiveDelete(new File(path));
    }

    public static void recursiveDelete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                TestUtils.recursiveDelete(f);
            }
        }
        file.delete();
    }

    public static void copyFiles(String from, String to) throws IOException {
        File src = new File(from);
        if (!src.exists()) {
            throw new IllegalArgumentException("File/Dir to copy does not exists:" + from);
        }
        File dest = new File(to);
        if (dest.exists() && !dest.isDirectory()) {
            throw new IllegalArgumentException("Cannot copy to '" + to + "', target exists and is not a directory.");
        }
        if (src.isFile()) {
            TestUtils.recursiveCopy(src, dest);
        }
        if (src.isDirectory()) {
            for (File f : src.listFiles()) {
                TestUtils.recursiveCopy(f, dest);
            }
        }
    }

    private static void recursiveCopy(File src, File dest) throws IOException {
        dest.mkdirs();
        if (src.isFile()) {
            String path = dest.getAbsolutePath();
            Files.copy(Paths.get(src.getAbsolutePath(), new String[0]), Paths.get(path, src.getName()), new CopyOption[0]);
            return;
        }
        if (src.isDirectory()) {
            String name = src.getName();
            Path p = Paths.get(dest.getAbsolutePath(), name);
            File newDest = new File(p.toString());
            for (File f : src.listFiles()) {
                TestUtils.recursiveCopy(f, newDest);
            }
        }
    }

    public static void startOutputCapture() {
        sout = System.out;
        out = new ByteArrayOutputStream(1000);
        PrintStream ps = new PrintStream(out);
        System.setOut(ps);
    }

    public static String getOutput() {
        return out.toString();
    }

    public static void endOutputCapture() {
        if (sout != null) {
            System.setOut(sout);
        }
    }

    public static String readFile(String path, String encoding) {
        try {
            byte[] data = Files.readAllBytes(Paths.get(path, new String[0]));
            return new String(data, encoding);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read file '" + path + "'", e);
        }
    }

    public static String readFile(String path, String encoding, boolean fail) {
        try {
            byte[] data = Files.readAllBytes(Paths.get(path, new String[0]));
            return new String(data, encoding);
        }
        catch (IOException e) {
            if (fail) {
                throw new RuntimeException("Failed to read file '" + path + "'", e);
            }
            return null;
        }
    }

    public static boolean checkContainsSame(List<? extends Object> list1, Collection<? extends Object> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        ArrayList<? extends Object> list3 = new ArrayList<Object>();
        list3.addAll(list1);
        list3.removeAll(list2);
        return list3.size() == 0;
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String[] replace(String separator, String template, String text) {
        int i1 = template.indexOf(separator);
        int sl = separator.length();
        int i2 = template.indexOf(separator, i1 + sl);
        if (i1 < 0 || i2 < 0) {
            return new String[]{text, template};
        }
        String content = template.substring(i1 + sl, i2);
        String[] result = new String[]{text, null};
        if (content.startsWith("UNTIL")) {
            String c = content.substring(5);
            int i3 = text.indexOf(c, i1);
            String pre = text.substring(0, i1);
            String post = text.substring(i3, text.length());
            result[0] = pre + post;
            result[1] = template = template.substring(0, i1) + c + template.substring(i2 + sl, template.length());
            result = TestUtils.replace(separator, template, result[0]);
        }
        return result;
    }
}

