/*
 * Decompiled with CFR 0.152.
 */
package osmo.common.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final String format = "{0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private Date date = new Date();
    private StringWriter sw = new StringWriter();
    private PrintWriter pw = new PrintWriter(this.sw);

    public LogFormatter() {
        this.formatter = new MessageFormat(format);
        this.args[0] = this.date;
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer line = new StringBuffer();
        try {
            long time = record.getMillis();
            this.date.setTime(time);
            this.formatter.format(this.args, line, (FieldPosition)null);
            line.append(" ");
            line.append(record.getLoggerName()).append(" - ");
            line.append(this.formatMessage(record)).append("\n");
            Throwable thrown = record.getThrown();
            if (thrown != null) {
                thrown.printStackTrace(this.pw);
                line.append(this.sw.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return line.toString();
    }
}

