/*
 * Decompiled with CFR 0.152.
 */
package osmo.common.log;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import osmo.common.log.LogFormatter;
import osmo.common.log.LogHandler;

public class Logger {
    private java.util.logging.Logger logger;
    public static Level fileLevel = null;
    public static Level consoleLevel = Level.SEVERE;
    public static String packageName = "";
    private static FileHandler file;
    private static LogHandler console;
    private static final Map<String, Level> levelMap;
    private static boolean useJul;

    public Logger(Class clazz) {
        String name = Logger.squeeze(clazz.getPackage().getName());
        name = name + clazz.getSimpleName();
        if (useJul) {
            this.initJUL(name);
        } else {
            this.init(name);
        }
    }

    private void initJUL(String name) {
        this.logger = java.util.logging.Logger.getLogger(name);
    }

    private static String squeeze(String orange) {
        String[] ps;
        String juice = "";
        for (String s : ps = orange.split("\\.")) {
            juice = juice + s.charAt(0) + ".";
        }
        return juice;
    }

    private synchronized void init(String name) {
        if (!name.startsWith(packageName)) {
            this.logger = null;
            return;
        }
        this.logger = java.util.logging.Logger.getLogger(name);
        this.logger.setUseParentHandlers(false);
        this.logger.setLevel(Level.ALL);
        console = new LogHandler();
        console.setFormatter(new LogFormatter());
        console.setLevel(consoleLevel);
        this.logger.addHandler(console);
        if (file != null) {
            this.logger.addHandler(file);
        }
    }

    public static void initFromFile() {
        String configurationFile = "osmo-tester.properties";
        try {
            FileInputStream fis = new FileInputStream(configurationFile);
            Properties props = new Properties();
            props.load(fis);
            useJul = Boolean.parseBoolean(props.getProperty("log.jdk", "false"));
            String logfile = props.getProperty("log.file.name", "osmo.log");
            String fileLogLevel = props.getProperty("log.file.level", "off");
            fileLevel = Logger.toLevel(fileLogLevel);
            file = new FileHandler(logfile, false);
            file.setFormatter(new LogFormatter());
            file.setLevel(fileLevel);
            String consoleLogLevel = props.getProperty("log.console.level", "off");
            consoleLevel = Logger.toLevel(consoleLogLevel);
            String packageFilter = props.getProperty("log.console.package", "");
            packageName = Logger.squeeze(packageFilter);
        }
        catch (IOException e) {
            file = null;
            new Logger(Logger.class).d("Unable to read logging configuration from file '" + configurationFile + "'. Using defaults.");
        }
    }

    public static Level toLevel(String text) {
        Level level = levelMap.get(text = text.toLowerCase());
        if (level == null) {
            throw new IllegalArgumentException("Unknown (file) log level definition:" + text);
        }
        return level;
    }

    public void d(String msg) {
        if (this.isOff()) {
            return;
        }
        this.logger.fine(msg);
    }

    private boolean isOff() {
        if (useJul) {
            return false;
        }
        if (consoleLevel == Level.OFF && fileLevel == Level.OFF) {
            return true;
        }
        return this.logger == null;
    }

    public void d(String msg, Throwable e) {
        if (this.isOff()) {
            return;
        }
        this.logger.log(Level.FINE, msg, e);
    }

    public void w(String msg) {
        if (this.isOff()) {
            return;
        }
        this.logger.warning(msg);
    }

    public void w(String msg, Throwable e) {
        if (this.isOff()) {
            return;
        }
        this.logger.log(Level.WARNING, msg, e);
    }

    public void i(String msg) {
        if (this.isOff()) {
            return;
        }
        this.logger.info(msg);
    }

    public void e(String msg, Throwable e) {
        if (this.isOff()) {
            return;
        }
        this.logger.log(Level.SEVERE, msg, e);
    }

    public void e(String msg) {
        if (this.isOff()) {
            return;
        }
        this.logger.log(Level.SEVERE, msg);
    }

    static {
        levelMap = new HashMap<String, Level>();
        useJul = false;
        levelMap.put("off", Level.OFF);
        levelMap.put("debug", Level.FINE);
        levelMap.put("warn", Level.WARNING);
        levelMap.put("error", Level.SEVERE);
        levelMap.put("info", Level.INFO);
        Logger.initFromFile();
        if (file != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(file::close));
        }
    }
}

