/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import osmo.tester.coverage.ScoreCalculator;
import osmo.tester.generator.SingleInstanceModelFactory;
import osmo.tester.generator.algorithm.FSMTraversalAlgorithm;
import osmo.tester.generator.algorithm.RandomAlgorithm;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.endcondition.Length;
import osmo.tester.generator.endcondition.Probability;
import osmo.tester.generator.endcondition.logical.And;
import osmo.tester.generator.filter.StepFilter;
import osmo.tester.generator.listener.GenerationListener;
import osmo.tester.generator.listener.GenerationListenerList;
import osmo.tester.model.FSM;
import osmo.tester.model.ModelFactory;
import osmo.tester.model.TestModels;
import osmo.tester.model.data.SearchableInput;
import osmo.tester.scenario.Scenario;
import osmo.tester.scripter.internal.TestScript;

public class OSMOConfiguration
implements ModelFactory {
    private EndCondition suiteEndCondition = new And(new Length(1), new Probability(0.05));
    private EndCondition testCaseEndCondition = new And(new Length(1), new Probability(0.1));
    private Collection<StepFilter> filters = new ArrayList<StepFilter>();
    private FSMTraversalAlgorithm algorithm;
    private boolean failWhenNoWayForward = true;
    private boolean stopTestOnError = true;
    private GenerationListenerList listeners = new GenerationListenerList();
    private int junitLength = -1;
    private boolean unwrapExceptions = true;
    private ModelFactory factory = null;
    private final SingleInstanceModelFactory defaultFactory = new SingleInstanceModelFactory();
    private static boolean manual = false;
    private Scenario scenario = null;
    private boolean sequenceTraceRequested = false;
    private boolean dataTraceRequested = false;
    private ScoreCalculator scoreCalculator;
    private boolean exploring = false;
    private boolean stopGenerationOnError = true;
    private boolean printExplorationErrors;
    private boolean keepTests = true;
    private List<TestScript> scripts = null;
    private boolean trackOptions = false;

    public OSMOConfiguration() {
    }

    public OSMOConfiguration(OSMOConfiguration cloneMe) {
        this.testCaseEndCondition = cloneMe.testCaseEndCondition.cloneMe();
        this.suiteEndCondition = cloneMe.suiteEndCondition.cloneMe();
        this.algorithm = cloneMe.algorithm;
        this.filters = cloneMe.filters;
        this.listeners = cloneMe.listeners;
        this.failWhenNoWayForward = cloneMe.failWhenNoWayForward;
        this.stopTestOnError = cloneMe.stopTestOnError;
        this.junitLength = cloneMe.junitLength;
        this.unwrapExceptions = cloneMe.unwrapExceptions;
        this.factory = cloneMe.factory;
        this.sequenceTraceRequested = cloneMe.sequenceTraceRequested;
        this.dataTraceRequested = cloneMe.dataTraceRequested;
        this.scoreCalculator = cloneMe.scoreCalculator;
        this.stopGenerationOnError = cloneMe.stopGenerationOnError;
        this.printExplorationErrors = cloneMe.printExplorationErrors;
        this.exploring = cloneMe.exploring;
        this.scenario = cloneMe.scenario;
        this.keepTests = cloneMe.keepTests;
        this.scripts = cloneMe.scripts;
        this.trackOptions = cloneMe.trackOptions;
    }

    public boolean isKeepTests() {
        return this.keepTests;
    }

    public void setKeepTests(boolean keepTests) {
        this.keepTests = keepTests;
    }

    public synchronized void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public synchronized Scenario getScenario() {
        return this.scenario;
    }

    public void setFactory(ModelFactory factory) {
        this.factory = factory;
    }

    public boolean isExploring() {
        return this.exploring;
    }

    public void setExploring(boolean exploring) {
        this.exploring = exploring;
    }

    public ModelFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.defaultFactory;
        }
        return this.factory;
    }

    public void addModelObject(String prefix, Object o) {
        this.defaultFactory.add(prefix, o);
    }

    public void addModelObject(Object o) {
        this.defaultFactory.add(o);
    }

    @Override
    public void createModelObjects(TestModels addHere) {
        this.factory = this.getFactory();
        this.factory.createModelObjects(addHere);
    }

    public void setAlgorithm(FSMTraversalAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public EndCondition getSuiteEndCondition() {
        return this.suiteEndCondition;
    }

    public EndCondition getTestCaseEndCondition() {
        return this.testCaseEndCondition;
    }

    public void setSuiteEndCondition(EndCondition condition) {
        this.suiteEndCondition = condition;
    }

    public void setTestEndCondition(EndCondition condition) {
        this.testCaseEndCondition = condition;
    }

    public void addFilter(StepFilter filter) {
        this.filters.add(filter);
        this.listeners.addListener(filter);
    }

    public boolean shouldStopTestOnError() {
        return this.stopTestOnError;
    }

    public boolean shouldFailWhenNoWayForward() {
        return this.failWhenNoWayForward;
    }

    public Collection<StepFilter> getFilters() {
        return this.filters;
    }

    public void addListener(GenerationListener listener) {
        this.listeners.addListener(listener);
    }

    public GenerationListenerList getListeners() {
        return this.listeners;
    }

    public void initialize(long seed, FSM fsm) {
        this.suiteEndCondition.init(seed, fsm, this);
        if (this.scenario != null) {
            this.scenario.validate(fsm);
            this.setTestEndCondition(this.scenario.createEndCondition(this.testCaseEndCondition));
        }
        this.listeners.init(seed, fsm, this);
    }

    public FSMTraversalAlgorithm cloneAlgorithm(long seed, FSM fsm) {
        if (this.algorithm == null) {
            this.algorithm = new RandomAlgorithm();
        }
        FSMTraversalAlgorithm clone = this.algorithm.cloneMe();
        clone.init(seed, fsm);
        return clone;
    }

    public void setStopTestOnError(boolean stop) {
        this.stopTestOnError = stop;
    }

    public void setFailWhenNoWayForward(boolean fail) {
        this.failWhenNoWayForward = fail;
    }

    public int getJUnitLength() {
        return this.junitLength;
    }

    public void setJUnitLength(int junitLength) {
        this.junitLength = junitLength;
    }

    public boolean shouldUnwrapExceptions() {
        return this.unwrapExceptions || this.junitLength > 0;
    }

    public void setUnwrapExceptions(boolean unwrapExceptions) {
        this.unwrapExceptions = unwrapExceptions;
    }

    public static void check(SearchableInput si) {
        if (si.isChecked()) {
            return;
        }
        si.setChecked(true);
        if (manual) {
            si.enableGUI();
        }
    }

    public void setManual(boolean manual) {
        OSMOConfiguration.manual = manual;
    }

    public boolean isSequenceTraceRequested() {
        return this.sequenceTraceRequested;
    }

    public void setSequenceTraceRequested(boolean sequenceTraceRequested) {
        this.sequenceTraceRequested = sequenceTraceRequested;
    }

    public boolean isDataTraceRequested() {
        return this.dataTraceRequested;
    }

    public void setDataTraceRequested(boolean dataTraceRequested) {
        this.dataTraceRequested = dataTraceRequested;
    }

    public void setScoreCalculator(ScoreCalculator scoreCalculator) {
        this.scoreCalculator = scoreCalculator;
    }

    public ScoreCalculator getScoreCalculator() {
        return this.scoreCalculator;
    }

    public void setStopGenerationOnError(boolean stopGenerationOnError) {
        this.stopGenerationOnError = stopGenerationOnError;
    }

    public boolean shouldStopGenerationOnError() {
        return this.stopGenerationOnError;
    }

    public boolean isPrintExplorationErrors() {
        return this.printExplorationErrors;
    }

    public void setPrintExplorationErrors(boolean printExplorationErrors) {
        this.printExplorationErrors = printExplorationErrors;
    }

    public List<TestScript> getScripts() {
        return this.scripts;
    }

    public void setScripts(List<TestScript> scripts) {
        this.scripts = scripts;
    }

    public boolean isTrackOptions() {
        return this.trackOptions;
    }

    public void setTrackOptions(boolean trackOptions) {
        this.trackOptions = trackOptions;
    }

    public OSMOConfiguration cloneMe() {
        return null;
    }
}

