/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester;

import java.util.List;
import java.util.logging.Level;
import osmo.common.TestUtils;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.coverage.ScoreCalculator;
import osmo.tester.coverage.ScoreConfiguration;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.MainGenerator;
import osmo.tester.generator.algorithm.FSMTraversalAlgorithm;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.filter.StepFilter;
import osmo.tester.generator.listener.GenerationListener;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.ModelFactory;
import osmo.tester.model.Requirements;
import osmo.tester.optimizer.CSVCoverageReport;
import osmo.tester.reporting.jenkins.JenkinsReportGenerator;
import osmo.tester.reporting.trace.TraceReportWriter;

public class OSMOTester {
    private static final Logger log = new Logger(OSMOTester.class);
    private FSM fsm = null;
    private OSMOConfiguration config = new OSMOConfiguration();
    private MainGenerator generator = null;
    private boolean printCoverage = true;

    public void setPrintCoverage(boolean printCoverage) {
        this.printCoverage = printCoverage;
    }

    public void setModelFactory(ModelFactory factory) {
        this.config.setFactory(factory);
    }

    public void addModelObject(Object modelObject) {
        this.config.addModelObject(modelObject);
    }

    public void addModelObject(String prefix, Object modelObject) {
        this.config.addModelObject(prefix, modelObject);
    }

    public void generate(long seed) {
        log.d("generator starting up");
        this.generator = this.initGenerator(seed);
        this.generator.generate();
        if (!this.printCoverage) {
            return;
        }
        TestSuite suite = this.generator.getSuite();
        List<TestCase> tests = suite.getAllTestCases();
        System.out.println("generated " + tests.size() + " tests.\n");
        TestCoverage tc = new TestCoverage(tests);
        String coverage = tc.coverageString(this.fsm, this.generator.getPossibleStepPairs(), null, null, null, false);
        System.out.println(coverage);
        Requirements requirements = suite.getRequirements();
        if (!requirements.isEmpty()) {
            System.out.println();
            System.out.println(requirements.printCoverage());
        }
        String filename = "osmo-output/osmo-" + seed;
        if (this.config.isSequenceTraceRequested()) {
            OSMOTester.writeTrace(filename, tests, seed, this.config);
        }
        if (!this.config.isExploring()) {
            OSMOTester.writeCoverageReport(filename, tests);
        }
    }

    public static synchronized void writeTrace(String filename, List<TestCase> tests, long seed, OSMOConfiguration config) {
        OSMOTester.createHtmlTrace(filename, tests);
        OSMOTester.createJenkinsReport(filename, tests, seed, config);
    }

    private static void writeCoverageReport(String filename, List<TestCase> tests) {
        String summary = "summary\n";
        CSVCoverageReport report = new CSVCoverageReport(new ScoreCalculator(new ScoreConfiguration()));
        report.process(tests);
        String totalCsv = report.report();
        totalCsv = totalCsv + summary + "\n";
        TestUtils.write(totalCsv, filename + ".csv");
    }

    private static void createHtmlTrace(String filename, List<TestCase> tests) {
        TraceReportWriter trace = new TraceReportWriter();
        try {
            trace.write(tests, filename + ".html");
        }
        catch (Exception e) {
            log.e("Failed to write trace", e);
        }
    }

    private static void createJenkinsReport(String filename, List<TestCase> tests, long seed, OSMOConfiguration config) {
        JenkinsReportGenerator jenkins = new JenkinsReportGenerator(null, false);
        jenkins.init(seed, null, config);
        jenkins.suiteStarted(null);
        for (TestCase test : tests) {
            jenkins.testEnded(test);
        }
        jenkins.suiteEnded(null);
        String report = jenkins.generateTestReport();
        TestUtils.write(report, filename + ".xml");
    }

    public MainGenerator initGenerator(long seed) {
        TestSuite suite = new TestSuite();
        if (this.config.isDataTraceRequested()) {
            suite.enableParameterTracking();
        }
        MainGenerator generator = new MainGenerator(seed, suite, this.config);
        this.fsm = generator.getFsm();
        return generator;
    }

    public TestSuite getSuite() {
        return this.generator.getSuite();
    }

    public FSM getFsm() {
        if (this.fsm == null) {
            this.initGenerator(0L);
        }
        return this.fsm;
    }

    public void setSuiteEndCondition(EndCondition condition) {
        this.config.setSuiteEndCondition(condition);
    }

    public void setTestEndCondition(EndCondition condition) {
        this.config.setTestEndCondition(condition);
    }

    public void setAlgorithm(FSMTraversalAlgorithm algorithm) {
        this.config.setAlgorithm(algorithm);
    }

    public void setDebug(boolean debug) {
        Logger.consoleLevel = debug ? Level.FINE : Level.INFO;
    }

    public void addListener(GenerationListener listener) {
        this.config.addListener(listener);
    }

    public void addFilter(StepFilter filter) {
        this.config.addFilter(filter);
    }

    public OSMOConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(OSMOConfiguration config) {
        this.config = config;
    }
}

