/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.coverage;

import java.util.ArrayList;
import java.util.List;
import osmo.common.log.Logger;
import osmo.tester.model.VariableValue;

public class CombinationCoverage
implements VariableValue<String> {
    private static final Logger log = new Logger(CombinationCoverage.class);
    private List<VariableValue> inputs = new ArrayList<VariableValue>();

    public CombinationCoverage(VariableValue ... inputs) {
        if (inputs == null || inputs.length == 0) {
            throw new IllegalArgumentException("You must specify some input variables to combine.");
        }
        for (VariableValue input : inputs) {
            if (input == null) {
                throw new NullPointerException("Input variable cannot be null.");
            }
            if (this.inputs.contains(input)) {
                throw new IllegalArgumentException("Variable only allowed once in combination:" + input);
            }
            this.inputs.add(input);
        }
    }

    @Override
    public String value() {
        String result = "";
        for (VariableValue input : this.inputs) {
            if (result.length() > 0) {
                result = result + "&";
            }
            result = result + "" + input.value();
        }
        return result;
    }

    public List<VariableValue> getInputs() {
        return this.inputs;
    }
}

