/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.coverage;

import java.util.ArrayList;
import java.util.Collection;
import osmo.tester.coverage.IntegerRange;
import osmo.tester.model.VariableValue;

public class RangeCategory
implements VariableValue {
    private Collection<IntegerRange> ranges = new ArrayList<IntegerRange>();
    private String value = null;
    private VariableValue<Integer> target = null;

    public RangeCategory() {
    }

    public RangeCategory(VariableValue<Integer> target) {
        this.target = target;
    }

    public String value() {
        if (this.target != null && this.target.value() != null) {
            this.process(this.target.value());
        }
        return this.value;
    }

    public RangeCategory zeroMany() {
        this.addCategory(0, 0, "zero");
        this.addCategory(1, Integer.MAX_VALUE, "many");
        return this;
    }

    public RangeCategory zeroOneMany() {
        this.addCategory(0, 0, "zero");
        this.addCategory(1, 1, "one");
        this.addCategory(2, Integer.MAX_VALUE, "many");
        return this;
    }

    public RangeCategory oneTwoMany() {
        this.addCategory(1, 1, "one");
        this.addCategory(2, 2, "two");
        this.addCategory(3, Integer.MAX_VALUE, "many");
        return this;
    }

    public RangeCategory addCategory(int min, int max, String name) {
        if (name == null) {
            throw new NullPointerException("Range name cannot be null.");
        }
        IntegerRange range = new IntegerRange(min, max, name);
        this.ranges.add(range);
        return this;
    }

    public RangeCategory process(int value) {
        boolean found = false;
        for (IntegerRange range : this.ranges) {
            if (value < range.min || value > range.max) continue;
            this.value = range.name;
            found = true;
        }
        if (!found) {
            this.value = null;
        }
        return this;
    }

    public Collection<IntegerRange> getRanges() {
        return this.ranges;
    }
}

