/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.coverage;

import java.util.Collection;
import java.util.Map;
import osmo.common.log.Logger;
import osmo.tester.coverage.ScoreConfiguration;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.testsuite.TestCase;

public class ScoreCalculator {
    private static final Logger log = new Logger(ScoreCalculator.class);
    private final ScoreConfiguration config;

    public ScoreCalculator(ScoreConfiguration config) {
        this.config = config;
    }

    public int calculateScore(TestCoverage tc) {
        int score = tc.getTotalSteps() * this.config.getLengthWeight();
        score += tc.getSingles().size() * this.config.getStepWeight();
        score += tc.getStepPairs().size() * this.config.getStepPairWeight();
        score += tc.getVariables().size() * this.config.getVariableCountWeight();
        score += tc.getStateCount() * this.config.getStateWeight();
        score += tc.getStatePairCount() * this.config.getStatePairWeight();
        Map<String, Collection<String>> values = tc.getVariableValues();
        for (String name : values.keySet()) {
            Collection<String> varValues = values.get(name);
            score += varValues.size() * this.config.getVariableWeight(name);
        }
        log.d("calculated score:" + (score += tc.getRequirements().size() * this.config.getRequirementWeight()));
        return score;
    }

    public int addedScoreFor(TestCoverage tc1, TestCase test) {
        TestCoverage tc2 = test.getCoverage();
        TestCoverage tc3 = tc2.cloneMe();
        tc3.addCoverage(tc1);
        int oldScore = this.calculateScore(tc1);
        int newScore = this.calculateScore(tc3);
        int added = newScore - oldScore;
        log.d("added score:" + added);
        return added;
    }
}

