/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.coverage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import osmo.common.log.Logger;
import osmo.tester.model.CoverageMethod;
import osmo.tester.model.FSM;
import osmo.tester.model.VariableField;

public class ScoreConfiguration {
    private static final Logger log = new Logger(ScoreConfiguration.class);
    protected int lengthWeight = -1;
    protected int variableCountWeight = 10;
    protected int defaultValueWeight = 1;
    protected Map<String, Integer> valueWeights = new LinkedHashMap<String, Integer>();
    protected int stepPairWeight = 30;
    protected int stepWeight = 20;
    protected int requirementWeight = 10;
    protected Collection<String> ignoreList = new LinkedHashSet<String>();
    private int stateWeight = 50;
    private int statePairWeight = 40;

    public void validate(FSM fsm) {
        log.d("validating against:" + fsm);
        Collection<VariableField> coverageVariables = fsm.getModelVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (VariableField variableField : coverageVariables) {
            variableNames.add(variableField.getName());
        }
        Collection<CoverageMethod> coverageMethods = fsm.getCoverageMethods();
        for (CoverageMethod coverageMethod : coverageMethods) {
            variableNames.add(coverageMethod.getVariableName());
            variableNames.add(coverageMethod.getPairName());
        }
        log.d("FSM variables for coverage:" + variableNames);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String name : this.valueWeights.keySet()) {
            if (variableNames.contains(name) || this.ignoreList.contains(name)) continue;
            linkedHashSet.add(name);
        }
        if (linkedHashSet.size() == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(linkedHashSet);
        Collections.sort(arrayList);
        log.d("Some required variables not found:" + arrayList);
        throw new IllegalArgumentException("Following coverage variables not found in the model:" + arrayList);
    }

    public int getLengthWeight() {
        return this.lengthWeight;
    }

    public void setLengthWeight(int lengthWeight) {
        this.lengthWeight = lengthWeight;
    }

    public int getVariableCountWeight() {
        return this.variableCountWeight;
    }

    public void setVariableCountWeight(int weight) {
        this.variableCountWeight = weight;
    }

    public int getVariableWeight(String name) {
        Integer weight = this.valueWeights.get(name);
        if (weight == null) {
            weight = this.defaultValueWeight;
        }
        return weight;
    }

    public int getStepPairWeight() {
        return this.stepPairWeight;
    }

    public void setStepPairWeight(int pairsWeight) {
        this.stepPairWeight = pairsWeight;
    }

    public int getStepWeight() {
        return this.stepWeight;
    }

    public void setStepWeight(int stepWeight) {
        this.stepWeight = stepWeight;
    }

    public void setRequirementWeight(int requirementWeight) {
        this.requirementWeight = requirementWeight;
    }

    public int getRequirementWeight() {
        return this.requirementWeight;
    }

    public Map<String, Integer> getValueWeights() {
        return this.valueWeights;
    }

    public void setDefaultValueWeight(int weight) {
        this.defaultValueWeight = weight;
    }

    public int getDefaultValueWeight() {
        return this.defaultValueWeight;
    }

    public void setVariableWeight(String name, int weight) {
        this.valueWeights.put(name, weight);
    }

    public void ignore(String ... names) {
        Collections.addAll(this.ignoreList, names);
    }

    public String toString() {
        return "ScoreConfiguration{lengthWeight=" + this.lengthWeight + ", variableCountWeight=" + this.variableCountWeight + ", defaultValueWeight=" + this.defaultValueWeight + ", stepPairWeight=" + this.stepPairWeight + ", stepWeight=" + this.stepWeight + ", requirementWeight=" + this.requirementWeight + '}';
    }

    public int getStateWeight() {
        return this.stateWeight;
    }

    public void setStateWeight(int stateWeight) {
        this.stateWeight = stateWeight;
    }

    public int getStatePairWeight() {
        return this.statePairWeight;
    }

    public void setStatePairWeight(int statePairWeight) {
        this.statePairWeight = statePairWeight;
    }
}

