/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.coverage;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import osmo.common.log.Logger;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;

public class TestCoverage {
    private static final Logger log = new Logger(TestCoverage.class);
    private Map<String, Integer> stepCount = new LinkedHashMap<String, Integer>();
    private Collection<String> stepPairs = new LinkedHashSet<String>();
    private Collection<String> singles = new LinkedHashSet<String>();
    private Collection<String> reqs = new LinkedHashSet<String>();
    private Collection<String> variables = new LinkedHashSet<String>();
    private Map<String, Collection<String>> variableValues = new LinkedHashMap<String, Collection<String>>();
    private Map<String, Collection<String>> coverageValues = new LinkedHashMap<String, Collection<String>>();
    private Map<String, Collection<String>> coverageValuePairs = new LinkedHashMap<String, Collection<String>>();
    private String previousStep = ".osmo.tester.start.step";
    private Map<String, String> previousCoverageValues = new LinkedHashMap<String, String>();
    private int totalSteps = 0;

    public TestCoverage() {
    }

    public TestCoverage(Collection<TestCase> tests) {
        for (TestCase test : tests) {
            this.addCoverage(test.getCoverage());
        }
    }

    public synchronized void addVariableValue(String name, String value) {
        this.checkAndAdd(name, value, this.variableValues);
        this.variables.add(name);
    }

    public synchronized void addUserCoverage(String name, String value) {
        this.checkAndAdd(name, value, this.coverageValues);
        String previousState = this.previousCoverageValues.get(name);
        if (previousState == null) {
            previousState = "osmo.tester.START_STATE";
        }
        String pair = previousState + "->" + value;
        this.previousCoverageValues.put(name, value);
        this.checkAndAdd(name + "-pair", pair, this.coverageValuePairs);
    }

    private void checkAndAdd(String name, String value, Map<String, Collection<String>> to) {
        Collection<String> values = to.get(name);
        if (values == null) {
            values = new LinkedHashSet<String>();
            to.put(name, values);
        }
        values.add(value);
    }

    public Map<String, Integer> getStepCoverage() {
        return this.stepCount;
    }

    public synchronized void addStep(String name) {
        this.increaseStepCount(name, 1);
        this.singles.add(name);
        this.stepPairs.add(this.previousStep + "->" + name);
        this.previousStep = name;
        ++this.totalSteps;
    }

    private void increaseStepCount(String name, int by) {
        Integer count = this.stepCount.get(name);
        if (count == null) {
            count = 0;
        }
        this.stepCount.put(name, count + by);
    }

    public int getTotalSteps() {
        return this.totalSteps;
    }

    public Collection<String> getStepPairs() {
        return this.stepPairs;
    }

    public Collection<String> getSingles() {
        return this.singles;
    }

    public Collection<String> getRequirements() {
        return this.reqs;
    }

    public Collection<String> getVariables() {
        return this.variables;
    }

    public Map<String, Collection<String>> getVariableValues() {
        return this.variableValues;
    }

    public int getValueCount() {
        int count = 0;
        for (Collection<String> strings : this.variableValues.values()) {
            count += strings.size();
        }
        return count;
    }

    public Map<String, Collection<String>> getStates() {
        return this.coverageValues;
    }

    public int getStateCount() {
        int count = 0;
        for (Collection<String> strings : this.coverageValues.values()) {
            count += strings.size();
        }
        return count;
    }

    public Map<String, Collection<String>> getStatePairs() {
        return this.coverageValuePairs;
    }

    public int getStatePairCount() {
        int count = 0;
        for (Collection<String> strings : this.coverageValuePairs.values()) {
            count += strings.size();
        }
        return count;
    }

    public synchronized TestCoverage cloneMe() {
        TestCoverage clone = new TestCoverage();
        TestCoverage.addCoverage(this, clone);
        return clone;
    }

    public synchronized void addCoverage(TestCoverage from) {
        TestCoverage.addCoverage(from, this);
    }

    private static void addCoverage(TestCoverage from, TestCoverage to) {
        Collection<String> values;
        to.stepPairs.addAll(from.stepPairs);
        to.totalSteps += from.totalSteps;
        for (String name : from.stepCount.keySet()) {
            to.increaseStepCount(name, from.stepCount.get(name));
        }
        to.reqs.addAll(from.reqs);
        to.singles.addAll(from.singles);
        to.variables.addAll(from.variables);
        for (String key : from.variableValues.keySet()) {
            values = to.variableValues.get(key);
            if (values == null) {
                values = new LinkedHashSet<String>();
                to.variableValues.put(key, values);
            }
            values.addAll(from.variableValues.get(key));
        }
        for (String key : from.coverageValues.keySet()) {
            values = to.coverageValues.get(key);
            if (values == null) {
                values = new LinkedHashSet<String>();
                to.coverageValues.put(key, values);
            }
            values.addAll(from.coverageValues.get(key));
        }
        for (String key : from.coverageValuePairs.keySet()) {
            values = to.coverageValuePairs.get(key);
            if (values == null) {
                values = new LinkedHashSet<String>();
                to.coverageValuePairs.put(key, values);
            }
            values.addAll(from.coverageValuePairs.get(key));
        }
    }

    public String toString() {
        return "TestCoverage{totalSteps=" + this.totalSteps + ", stepPairs=" + this.stepPairs + ", singles=" + this.singles + ", reqs=" + this.reqs + ", variables=" + this.variables + ", variableValues=" + this.variableValues + ", coverageValues=" + this.coverageValues + ", coverageValuePairs=" + this.coverageValuePairs + '}';
    }

    public String coverageString(FSM fsm, Collection<String> possibleStepPairs, Map<String, Collection<String>> possibleValues, Map<String, Collection<String>> possibleCVs, Map<String, Collection<String>> possibleCVPairs, boolean printAll) {
        String result = "Covered elements:\n";
        result = result + "Total steps: " + this.totalSteps;
        result = this.stepCoverageString(fsm, result);
        result = this.stepPairCoverageString(possibleStepPairs, printAll, result);
        result = result + "\nUnique requirements: " + this.reqs.size();
        result = result + this.countString("Variable values", this.getValueCount(), possibleValues);
        result = result + this.countString("Unique coverage-values", this.getStateCount(), possibleCVs);
        result = result + this.countString("Unique coverage-value-pairs", this.getStatePairCount(), possibleCVPairs);
        return result;
    }

    private String stepPairCoverageString(Collection<String> possibleStepPairs, boolean printAll, String result) {
        result = result + "\nUnique step-pairs: " + this.stepPairs.size();
        if (possibleStepPairs != null && possibleStepPairs.size() > 0) {
            LinkedHashSet<String> all = new LinkedHashSet<String>();
            all.addAll(possibleStepPairs);
            all.removeAll(this.stepPairs);
            result = result + " (of " + possibleStepPairs.size() + ")";
            if (printAll || all.size() > 0 && all.size() < 5) {
                result = result + " missing:" + all;
            }
        }
        return result;
    }

    private String stepCoverageString(FSM fsm, String result) {
        result = result + "\nUnique steps: " + this.singles.size();
        if (fsm != null) {
            Collection<FSMTransition> fsmTransitions = fsm.getTransitions();
            int fsmMax = fsmTransitions.size();
            result = result + " (of " + fsmMax + ")";
            if (fsmMax > this.singles.size()) {
                LinkedHashSet<String> all = new LinkedHashSet<String>();
                for (FSMTransition ft : fsmTransitions) {
                    all.add(ft.getStringName());
                }
                all.removeAll(this.singles);
                result = result + " missing:" + all;
            }
        }
        return result;
    }

    private String countString(String name, int count, Map<String, Collection<String>> possibleValues) {
        String result = "\n" + name + ": " + count;
        if (possibleValues != null && possibleValues.size() > 0) {
            int possibleValueCount = 0;
            for (Collection<String> strings : possibleValues.values()) {
                possibleValueCount += strings.size();
            }
            result = result + " (of " + possibleValueCount + ")";
        }
        return result;
    }

    public void removeAll(TestCoverage in) {
        Collection<String> myValues;
        Collection<String> yourValues;
        this.singles.removeAll(in.singles);
        this.stepPairs.removeAll(in.stepPairs);
        this.reqs.removeAll(in.reqs);
        this.variables.removeAll(in.variables);
        for (String var : this.variableValues.keySet()) {
            yourValues = in.variableValues.get(var);
            if (yourValues == null) continue;
            myValues = this.variableValues.get(var);
            myValues.removeAll(yourValues);
        }
        for (String var : this.coverageValues.keySet()) {
            yourValues = in.coverageValues.get(var);
            if (yourValues == null) continue;
            myValues = this.coverageValues.get(var);
            myValues.removeAll(yourValues);
        }
        for (String var : this.coverageValuePairs.keySet()) {
            yourValues = in.coverageValuePairs.get(var);
            if (yourValues == null) continue;
            myValues = this.coverageValuePairs.get(var);
            myValues.removeAll(yourValues);
        }
    }

    public void coveredRequirement(String name) {
        this.reqs.add(name);
    }
}

