/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.explorer;

import osmo.tester.OSMOConfiguration;
import osmo.tester.coverage.ScoreCalculator;
import osmo.tester.coverage.ScoreConfiguration;
import osmo.tester.explorer.ExplorationEndCondition;
import osmo.tester.generator.algorithm.FSMTraversalAlgorithm;
import osmo.tester.generator.algorithm.RandomAlgorithm;
import osmo.tester.model.FSM;
import osmo.tester.model.ModelFactory;
import osmo.tester.scenario.Scenario;

public class ExplorationConfiguration
extends ScoreConfiguration {
    protected ModelFactory factory;
    protected int depth;
    protected int minTestLength = 10;
    protected int maxTestLength = 50;
    protected int minSuiteLength = 10;
    protected int maxSuiteLength = 20;
    protected int minTestScore = 0;
    protected int minSuiteScore = 0;
    protected int testPlateauThreshold = 1;
    protected int testPlateauLength = 1;
    protected int suitePlateauThreshold = 1;
    protected double fallbackProbability = 0.2;
    protected ExplorationEndCondition endCondition = null;
    protected int timeout = 1800;
    private final long seed;
    private FSMTraversalAlgorithm fallback;
    private boolean printAll = false;
    private int parallelism = Runtime.getRuntime().availableProcessors();
    private Scenario scenario;
    private boolean failWhenNoWayForward;
    private boolean stopGenerationOnError;

    public ExplorationConfiguration(ModelFactory factory, int depth, long seed) {
        this.factory = factory;
        this.depth = depth;
        this.seed = seed;
        this.lengthWeight = 0;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public boolean isPrintAll() {
        return this.printAll;
    }

    public void setPrintAll(boolean printAll) {
        this.printAll = printAll;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setFactory(ModelFactory factory) {
        this.factory = factory;
    }

    public ModelFactory getModelFactory() {
        return this.factory;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void fillOSMOConfiguration(OSMOConfiguration config) {
        this.endCondition = new ExplorationEndCondition(this);
        config.setScoreCalculator(new ScoreCalculator(this));
        config.setSuiteEndCondition(this.endCondition);
        config.setTestEndCondition(this.endCondition);
        config.setFactory(this.factory);
        config.setScenario(this.scenario);
        config.setFailWhenNoWayForward(this.failWhenNoWayForward);
        config.setStopGenerationOnError(this.stopGenerationOnError);
    }

    public int getMinTestLength() {
        return this.minTestLength;
    }

    public void setMinTestLength(int minTestLength) {
        this.minTestLength = minTestLength;
    }

    public int getMaxTestLength() {
        return this.maxTestLength;
    }

    public void setMaxTestLength(int maxTestLength) {
        this.maxTestLength = maxTestLength;
    }

    public int getMinSuiteLength() {
        return this.minSuiteLength;
    }

    public void setMinSuiteLength(int minSuiteLength) {
        this.minSuiteLength = minSuiteLength;
    }

    public int getMaxSuiteLength() {
        return this.maxSuiteLength;
    }

    public void setMaxSuiteLength(int maxSuiteLength) {
        this.maxSuiteLength = maxSuiteLength;
    }

    public int getMinTestScore() {
        return this.minTestScore;
    }

    public void setMinTestScore(int minTestScore) {
        this.minTestScore = minTestScore;
    }

    public int getMinSuiteScore() {
        return this.minSuiteScore;
    }

    public void setMinSuiteScore(int minSuiteScore) {
        this.minSuiteScore = minSuiteScore;
    }

    public ExplorationEndCondition getExplorationEndCondition() {
        return this.endCondition;
    }

    public int getTestPlateauThreshold() {
        return this.testPlateauThreshold;
    }

    public void setTestPlateauThreshold(int testPlateauThreshold) {
        this.testPlateauThreshold = testPlateauThreshold;
    }

    public int getTestPlateauLength() {
        return this.testPlateauLength;
    }

    public void setTestPlateauLength(int testPlateauLength) {
        this.testPlateauLength = testPlateauLength;
    }

    public int getSuitePlateauThreshold() {
        return this.suitePlateauThreshold;
    }

    public void setSuitePlateauThreshold(int suitePlateauThreshold) {
        this.suitePlateauThreshold = suitePlateauThreshold;
    }

    public FSMTraversalAlgorithm getFallback(long seed, FSM fsm) {
        if (this.fallback == null) {
            this.setFallback(new RandomAlgorithm(), seed, fsm);
        }
        FSMTraversalAlgorithm clone = this.fallback.cloneMe();
        clone.init(seed, fsm);
        clone.initTest(seed);
        return clone;
    }

    public void setFallback(FSMTraversalAlgorithm fallback, long seed, FSM fsm) {
        this.fallback = fallback;
        fallback.init(seed, fsm);
        fallback.initTest(seed);
    }

    public double getFallbackProbability() {
        return this.fallbackProbability;
    }

    public void setFallbackProbability(double fallbackProbability) {
        this.fallbackProbability = fallbackProbability;
    }

    @Override
    public void validate(FSM fsm) {
        double probability;
        super.validate(fsm);
        String errors = "";
        boolean suiteLength = this.minSuiteLength > 0;
        boolean suiteScore = this.minSuiteScore > 0;
        boolean testLength = this.minTestLength > 0;
        boolean testScore = this.minTestScore > 0;
        String ln = System.lineSeparator();
        if (!suiteLength && !suiteScore) {
            errors = errors + "Exploration requires defining either minimum suite length or minimum suite score." + ln;
        }
        if (!testLength && !testScore) {
            errors = errors + "Exploration requires defining either minimum test length or minimum test score." + ln;
        }
        if (this.maxSuiteLength > 0 && this.minSuiteLength > 0 && this.maxSuiteLength < this.minSuiteLength) {
            errors = errors + "Suite minimum length must be less than maximum length." + ln;
        }
        if (this.maxTestLength > 0 && this.minTestLength > 0 && this.maxTestLength < this.minTestLength) {
            errors = errors + "Test case minimum length must be less than maximum length." + ln;
        }
        if ((probability = this.fallbackProbability) < 0.0 || probability > 1.0) {
            errors = errors + "Fallback probability must be between 0 and 1. Was " + probability + ".";
        }
        if (errors.length() > 0) {
            errors = "Invalid exploration configuration:" + ln + errors;
            throw new IllegalArgumentException(errors);
        }
    }

    @Override
    public String toString() {
        return "ExplorationConfiguration{\nfactory=" + this.factory.getClass() + ",\n depth=" + this.depth + ",\n minTestLength=" + this.minTestLength + ",\n maxTestLength=" + this.maxTestLength + ",\n minSuiteLength=" + this.minSuiteLength + ",\n maxSuiteLength=" + this.maxSuiteLength + ",\n minTestScore=" + this.minTestScore + ",\n minSuiteScore=" + this.minSuiteScore + ",\n testPlateauThreshold=" + this.testPlateauThreshold + ",\n suitePlateauThreshold=" + this.suitePlateauThreshold + ",\n fallbackProbability=" + this.fallbackProbability + ",\n endCondition=" + this.endCondition + ",\n timeout=" + this.timeout + "}\n " + super.toString();
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public void setFailWhenNoWayForward(boolean failWhenNoWayForward) {
        this.failWhenNoWayForward = failWhenNoWayForward;
    }

    public boolean isFailWhenNoWayForward() {
        return this.failWhenNoWayForward;
    }

    public void setStopGenerationOnError(boolean stopGenerationOnError) {
        this.stopGenerationOnError = stopGenerationOnError;
    }

    public boolean isStopGenerationOnError() {
        return this.stopGenerationOnError;
    }
}

