/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.explorer;

import java.util.ArrayList;
import java.util.List;
import osmo.common.Randomizer;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.coverage.ScoreCalculator;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.explorer.ExplorationConfiguration;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.scenario.Scenario;

public class ExplorationEndCondition
implements EndCondition {
    private static final Logger log = new Logger(ExplorationEndCondition.class);
    private final ExplorationConfiguration config;
    private double fallbackProbability;
    private Randomizer rand;
    private long seed;
    private long startTime = 0L;
    private final ScoreCalculator scoreCalculator;
    private TestCoverage suiteCoverage;
    private final boolean exploring;
    private final EndCondition scenarioEndCondition;

    public ExplorationEndCondition(ExplorationConfiguration config) {
        this(config, null, false);
    }

    public ExplorationEndCondition(ExplorationConfiguration config, TestCoverage suiteCoverage, boolean exploring) {
        this.config = config;
        this.scoreCalculator = new ScoreCalculator(config);
        this.fallbackProbability = config.getFallbackProbability();
        this.startTime = System.currentTimeMillis();
        this.suiteCoverage = suiteCoverage;
        this.exploring = exploring;
        Scenario scenario = config.getScenario();
        this.scenarioEndCondition = scenario != null ? scenario.createEndCondition(null) : null;
    }

    @Override
    public boolean endSuite(TestSuite suite, FSM fsm) {
        List<TestCase> tests = suite.getAllTestCases();
        TestCoverage coverage = suite.getCoverage();
        return this.isSuiteFinished(tests, coverage);
    }

    public boolean isSuiteFinished(List<TestCase> suite, TestCoverage tc) {
        if (this.isTimedOut()) {
            return true;
        }
        int max = this.config.getMaxSuiteLength();
        int suiteSize = suite.size();
        if (max > 0 && suiteSize >= max) {
            return true;
        }
        int min = this.config.getMinSuiteLength();
        if (min > 0 && suiteSize < min) {
            return false;
        }
        int plateauThreshold = this.config.getSuitePlateauThreshold();
        if (plateauThreshold > 0 && this.isSuitePlateau(suite, tc, 2)) {
            return true;
        }
        int minScore = this.config.getMinSuiteScore();
        if (minScore > 0 && this.scoreCalculator.calculateScore(tc) < minScore) {
            return false;
        }
        if (this.exploring) {
            return true;
        }
        double v = this.rand.nextDouble();
        return v < this.fallbackProbability;
    }

    @Override
    public boolean endTest(TestSuite suite, FSM fsm) {
        if (this.scenarioEndCondition != null && !this.scenarioEndCondition.endTest(suite, fsm)) {
            return false;
        }
        if (this.isTimedOut()) {
            log.d("Exploration timeout");
            return true;
        }
        int max = this.config.getMaxTestLength();
        int testSteps = suite.currentSteps();
        if (max > 0 && testSteps >= max) {
            log.d("test over maximum length");
            return true;
        }
        int min = this.config.getMinTestLength();
        if (min > 0 && testSteps < min) {
            return false;
        }
        long mySeed = this.seed + (long)suite.totalSteps();
        int plateauThreshold = this.config.getTestPlateauThreshold();
        if (plateauThreshold > 0 && this.isTestPlateau(suite, this.config.getTestPlateauLength())) {
            log.d("test has plateaued");
            return this.checkProbability(mySeed);
        }
        int minScore = this.config.getMinTestScore();
        if (minScore > 0) {
            TestCase test;
            TestCaseStep step;
            if (this.suiteCoverage == null) {
                this.suiteCoverage = suite.getCoverage();
            }
            if ((step = (test = suite.getCurrentTest()).getCurrentStep()) == null) {
                return false;
            }
            int added = step.getAddedCoverage();
            if (added < minScore) {
                return false;
            }
        }
        if (this.exploring) {
            return true;
        }
        return this.checkProbability(mySeed);
    }

    private boolean checkProbability(long mySeed) {
        Randomizer rand = new Randomizer(mySeed);
        double v = rand.nextDouble();
        log.d("randomizing..:" + v);
        return v < this.fallbackProbability;
    }

    private boolean isTimedOut() {
        if (this.config.getTimeout() <= 0) {
            return false;
        }
        long now = System.currentTimeMillis();
        long diff = now - this.startTime;
        return diff > (long)(this.config.getTimeout() * 1000);
    }

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration osmoConfig) {
        this.seed = seed;
        this.rand = new Randomizer(seed);
        if (fsm != null) {
            this.config.validate(fsm);
        }
    }

    private boolean isSuitePlateau(List<TestCase> suite, TestCoverage suiteCoverage, int size) {
        if (suite.size() < size) {
            return false;
        }
        ArrayList<TestCase> suiteClone = new ArrayList<TestCase>();
        suiteClone.addAll(suite);
        for (int i = 0; i < size; ++i) {
            suiteClone.remove(suiteClone.size() - 1);
        }
        TestCoverage cloneTC = new TestCoverage(suiteClone);
        int before = this.scoreCalculator.calculateScore(cloneTC);
        int after = this.scoreCalculator.calculateScore(suiteCoverage);
        int diff = after - before;
        return diff < this.config.getSuitePlateauThreshold();
    }

    private boolean isTestPlateau(TestSuite suite, int steps) {
        int before;
        TestCase currentTest = suite.getCurrentTest();
        int length = currentTest.getSteps().size();
        int index = length - (steps + 1);
        if (index < steps) {
            return false;
        }
        int now = currentTest.getCurrentStep().getAddedCoverage();
        int diff = now - (before = currentTest.getSteps().get(index).getAddedCoverage());
        return diff < this.config.getTestPlateauThreshold();
    }

    @Override
    public EndCondition cloneMe() {
        ExplorationEndCondition clone = new ExplorationEndCondition(this.config, this.suiteCoverage, this.exploring);
        clone.seed = this.seed;
        clone.rand = new Randomizer(this.seed);
        return clone;
    }
}

