/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.explorer;

import java.util.Collection;
import java.util.List;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.explorer.ExplorationConfiguration;
import osmo.tester.explorer.ExplorationState;
import osmo.tester.generator.MainGenerator;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSMTransition;

public class ExplorationHelper {
    private static final Logger log = new Logger(ExplorationHelper.class);

    public static MainGenerator initPath(ExplorationState state, Collection<String> path) {
        return ExplorationHelper.initPath(state, path, false);
    }

    public static MainGenerator initPath(ExplorationState state, Collection<String> path, boolean end) {
        MainGenerator generator = ExplorationHelper.createGenerator(state);
        ExplorationHelper.runScript(generator, path, end);
        return generator;
    }

    public static void runScript(MainGenerator generator, Collection<String> path, boolean endTest) {
        generator.beforeTest();
        for (String step : path) {
            ExplorationHelper.execute(generator, step);
        }
        if (endTest) {
            generator.afterTest();
        }
    }

    public static void execute(MainGenerator generator, String step) {
        List<FSMTransition> enabled = generator.getEnabled();
        FSMTransition transition = null;
        for (FSMTransition option : enabled) {
            if (!option.getStringName().equals(step)) continue;
            transition = option;
            break;
        }
        if (transition == null) {
            throw new NullPointerException("Explorer was unable to find a step with the name '" + step + "'");
        }
        generator.execute(transition);
    }

    private static MainGenerator createGenerator(ExplorationState state) {
        ExplorationConfiguration config = state.getConfig();
        TestCoverage suiteCoverage = state.getSuiteCoverage().cloneMe();
        TestSuite suite = new TestSuite(suiteCoverage);
        OSMOConfiguration oc = new OSMOConfiguration();
        config.fillOSMOConfiguration(oc);
        MainGenerator generator = new MainGenerator(state.getConfig().getSeed(), suite, oc);
        generator.invokeAll(generator.getFsm().getExplorationEnablers());
        generator.initSuite();
        generator.getSuite().setKeepTests(false);
        return generator;
    }
}

