/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import osmo.common.log.Logger;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.explorer.ExplorationConfiguration;
import osmo.tester.explorer.ExplorationEndCondition;
import osmo.tester.explorer.ExplorationState;
import osmo.tester.explorer.MainExplorer;
import osmo.tester.explorer.trace.DOTWriter;
import osmo.tester.explorer.trace.TimeTrace;
import osmo.tester.explorer.trace.TraceNode;
import osmo.tester.generator.algorithm.FSMTraversalAlgorithm;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;

public class ExplorerAlgorithm
implements FSMTraversalAlgorithm {
    private static final Logger log = new Logger(ExplorerAlgorithm.class);
    private final ExplorationConfiguration config;
    private final ExplorationEndCondition explorationEndCondition;
    private DOTWriter dot = new DOTWriter(1);
    private MainExplorer currentExplorer = null;
    private static final Collection<String> possibleStepPairs = new LinkedHashSet<String>();
    private static final Map<String, Collection<String>> possibleValues = new LinkedHashMap<String, Collection<String>>();
    private static final Map<String, Collection<String>> possibleStates = new LinkedHashMap<String, Collection<String>>();
    private static final Map<String, Collection<String>> possibleStatePairs = new LinkedHashMap<String, Collection<String>>();
    private FSM fsm = null;
    private Collection<TimeTrace> traces = new ArrayList<TimeTrace>();
    public static boolean trackCoverage = false;

    public ExplorerAlgorithm(ExplorationConfiguration config) {
        this.config = config;
        this.explorationEndCondition = config.getExplorationEndCondition();
    }

    @Override
    public void init(long seed, FSM fsm) {
        DOTWriter.deleteFiles();
        this.fsm = fsm;
        this.config.getFallback(seed, fsm);
    }

    public Collection<TimeTrace> getTraces() {
        return this.traces;
    }

    @Override
    public FSMTransition choose(TestSuite suite, List<FSMTransition> choices) {
        int testIndex = suite.getAllTestCases().size();
        List<String> path = suite.getCurrentTest().getAllStepNames();
        log.d("path for the current (explored) test:" + path);
        log.i("Exploring step " + testIndex + "." + path.size());
        TestCoverage suiteCoverage = suite.getCoverage();
        TraceNode[] trace = this.initTrace(path, testIndex);
        ExplorationState state = new ExplorationState(this.config, suiteCoverage);
        String choice = null;
        if (choices.size() == 1) {
            choice = choices.get(0).getStringName();
            path.add(choice);
        } else {
            choice = this.exploreLocal(suite, state, path, trace[1]);
        }
        this.writeDot(path, trace[0]);
        for (FSMTransition transition : choices) {
            if (!transition.getStringName().equals(choice)) continue;
            return transition;
        }
        throw new IllegalStateException("Exploration choice (" + choice + ") not available. OSMO is bugging?");
    }

    private void writeDot(List<String> path, TraceNode traceRoot) {
        String top = "root";
        if (path.size() > 0) {
            top = path.get(path.size() - 1);
        }
        this.dot.write(traceRoot, this.config.getDepth() - 1, top);
    }

    @Override
    public void initTest(long seed) {
        if (this.currentExplorer != null) {
            this.currentExplorer.stop();
        }
        this.currentExplorer = null;
    }

    private String exploreLocal(TestSuite suite, ExplorationState state, List<String> path, TraceNode root) {
        if (this.currentExplorer == null) {
            this.currentExplorer = new MainExplorer(root);
            this.currentExplorer.init(this.fsm, suite, state, path, this.config.getParallelism());
            this.currentExplorer.explore();
        }
        String result = this.currentExplorer.getResult();
        int test = suite.getAllTestCases().size();
        int step = suite.getCurrentTest().getSteps().size() + 1;
        TimeTrace trace = new TimeTrace(test, step, result, this.currentExplorer.getDuration());
        this.traces.add(trace);
        if (trackCoverage) {
            Collection<String> possibles;
            Map<String, Collection<String>> observed = this.currentExplorer.getPossibleVariableValues();
            for (String key : observed.keySet()) {
                possibles = possibleValues.get(key);
                if (possibles == null) {
                    possibles = new LinkedHashSet<String>();
                    possibleValues.put(key, possibles);
                }
                possibles.addAll(observed.get(key));
            }
            observed = this.currentExplorer.getPossibleStates();
            for (String key : observed.keySet()) {
                possibles = possibleStates.get(key);
                if (possibles == null) {
                    possibles = new LinkedHashSet<String>();
                    possibleStates.put(key, possibles);
                }
                possibles.addAll(observed.get(key));
            }
            observed = this.currentExplorer.getPossibleStatePairs();
            for (String key : observed.keySet()) {
                possibles = possibleStatePairs.get(key);
                if (possibles == null) {
                    possibles = new LinkedHashSet<String>();
                    possibleStatePairs.put(key, possibles);
                }
                possibles.addAll(observed.get(key));
            }
            possibleStepPairs.addAll(this.currentExplorer.getPossibleStepPairs());
        }
        if (this.explorationEndCondition.endTest(suite, null)) {
            this.currentExplorer.stop();
            this.currentExplorer = null;
        } else {
            this.currentExplorer.stop();
            ArrayList<String> newScript = new ArrayList<String>();
            newScript.addAll(path);
            newScript.add(result);
            this.currentExplorer = new MainExplorer(root);
            this.currentExplorer.init(this.fsm, suite, state, newScript, this.config.getParallelism());
            this.currentExplorer.explore();
        }
        return result;
    }

    private TraceNode[] initTrace(Collection<String> script, int testIndex) {
        TraceNode root;
        if (this.dot.getTestIndex() != testIndex) {
            log.d("New test started, creating new DOT tracer.");
            this.dot = new DOTWriter(testIndex);
        }
        TraceNode.reset();
        TraceNode[] nodes = new TraceNode[2];
        nodes[0] = root = new TraceNode("init", null, false);
        TraceNode node = root;
        for (String step : script) {
            node = node.add(step, false);
        }
        nodes[1] = node;
        return nodes;
    }

    public ExplorationEndCondition getExplorationEndCondition() {
        return this.explorationEndCondition;
    }

    public Collection<String> getPossibleStepPairs() {
        return possibleStepPairs;
    }

    public Map<String, Collection<String>> getPossibleValues() {
        return possibleValues;
    }

    public Map<String, Collection<String>> getPossibleStates() {
        return possibleStates;
    }

    public Map<String, Collection<String>> getPossibleStatePairs() {
        return possibleStatePairs;
    }

    @Override
    public FSMTraversalAlgorithm cloneMe() {
        ExplorerAlgorithm clone = new ExplorerAlgorithm(this.config);
        return clone;
    }
}

