/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import osmo.common.log.Logger;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.explorer.ExplorationConfiguration;
import osmo.tester.explorer.ExplorationHelper;
import osmo.tester.explorer.ExplorationState;
import osmo.tester.explorer.PathExplorer;
import osmo.tester.explorer.trace.TraceNode;
import osmo.tester.generator.MainGenerator;
import osmo.tester.generator.algorithm.FSMTraversalAlgorithm;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;

public class MainExplorer
implements Runnable {
    private static final Logger log = new Logger(MainExplorer.class);
    private final TraceNode trace;
    private List<String> script;
    private ExplorationState state;
    private static ForkJoinPool explorationPool;
    private String result = null;
    private TestSuite suite = null;
    private FSM fsm = null;
    private boolean shouldStop = false;
    private final Collection<String> possibleStepPairs = new LinkedHashSet<String>();
    private final Map<String, Collection<String>> possibleVVs = new LinkedHashMap<String, Collection<String>>();
    private final Map<String, Collection<String>> possibleStates = new LinkedHashMap<String, Collection<String>>();
    private final Map<String, Collection<String>> possibleStatePairs = new LinkedHashMap<String, Collection<String>>();
    private long starttime = 0L;
    private long endtime = 0L;
    private int longest = 0;

    public MainExplorer(TraceNode trace) {
        this.trace = trace;
    }

    public long getDuration() {
        return this.endtime - this.starttime;
    }

    public void init(FSM fsm, TestSuite suite, ExplorationState state, List<String> script, int parallelism) {
        if (explorationPool == null) {
            explorationPool = new ForkJoinPool(parallelism);
        }
        this.fsm = fsm;
        this.suite = suite;
        this.state = state;
        this.script = script;
    }

    public void explore() {
        this.starttime = System.currentTimeMillis();
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.runrun();
        }
        catch (Exception e) {
            if (this.shouldStop) {
                return;
            }
            e.printStackTrace();
            throw e;
        }
        finally {
            MainExplorer mainExplorer = this;
            synchronized (mainExplorer) {
                this.shouldStop = true;
                this.notifyAll();
            }
        }
    }

    public void runrun() {
        MainGenerator generator = ExplorationHelper.initPath(this.state, this.script);
        List<FSMTransition> enabled = generator.getEnabled();
        ExplorationConfiguration config = this.state.getConfig();
        PathExplorer explorer = new PathExplorer(this.state, config.getDepth() - 1, this.trace, enabled, this.script, explorationPool);
        List<TestCase> testCases = explorationPool.invoke(explorer);
        if (this.shouldStop || testCases == null) {
            log.d("Exploration has stopped on the fly.");
            return;
        }
        if (testCases.size() == 0) {
            log.d("No test cases to choose from. Assuming empty set, where no transition enabled.");
            this.shouldStop = true;
            return;
        }
        String best = this.findBest(testCases);
        this.setResult(best);
    }

    private synchronized void setResult(String result) {
        this.endtime = System.currentTimeMillis();
        this.result = result;
        this.notifyAll();
    }

    public synchronized String getResult() {
        while (this.result == null && !this.shouldStop) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                log.e("Wait interrupted", e);
            }
        }
        return this.result;
    }

    public String findBest(List<TestCase> from) {
        log.d("finding best from:" + from);
        this.collectMetrics(from);
        List<TestCase> choices = this.pruneBest(from, -1);
        log.d("pruned:" + choices);
        return this.findBestFrom(choices, this.script.size());
    }

    private void collectMetrics(List<TestCase> from) {
        TestCoverage tc = new TestCoverage(from);
        this.collectPossible(tc.getVariableValues(), this.possibleVVs);
        this.collectPossible(tc.getStates(), this.possibleStates);
        this.collectPossible(tc.getStatePairs(), this.possibleStatePairs);
        this.possibleStepPairs.addAll(tc.getStepPairs());
    }

    private void collectPossible(Map<String, Collection<String>> observed, Map<String, Collection<String>> to) {
        for (String key : observed.keySet()) {
            Collection<String> possibles = to.get(key);
            if (possibles == null) {
                possibles = new LinkedHashSet<String>();
                to.put(key, possibles);
            }
            possibles.addAll(observed.get(key));
        }
    }

    private List<TestCase> pruneBest(Collection<TestCase> choices, int count) {
        this.longest = 0;
        int highest = Integer.MIN_VALUE;
        ArrayList<TestCase> optimum = new ArrayList<TestCase>();
        for (TestCase test : choices) {
            int length = test.getAllStepNames().size();
            if (count >= length) continue;
            TestCaseStep step = null;
            step = count < 0 ? test.getCurrentStep() : test.getSteps().get(count);
            int score = step.getAddedCoverage();
            if (score > highest) {
                optimum.clear();
                highest = score;
            }
            if (score != highest) continue;
            if (length > this.longest) {
                this.longest = length;
            }
            optimum.add(test);
        }
        if (optimum.size() == 0) {
            optimum.addAll(choices);
        }
        return optimum;
    }

    public String findBestFrom(List<TestCase> from, int count) {
        List<TestCase> optimum = this.pruneBest(from, count);
        if (this.longest > count + 1 && optimum.size() > 1) {
            return this.findBestFrom(optimum, count + 1);
        }
        ArrayList<FSMTransition> choices = new ArrayList<FSMTransition>();
        int index = this.script.size();
        for (TestCase tc : optimum) {
            String tn = tc.getSteps().get(index).getName();
            FSMTransition t = this.fsm.getTransition(tn);
            choices.add(t);
        }
        ExplorationConfiguration config = this.state.getConfig();
        int salt = this.state.getSuiteCoverage().getTotalSteps();
        long seed = config.getSeed() + (long)salt;
        FSMTraversalAlgorithm fallback = config.getFallback(seed, this.fsm);
        FSMTransition choice = fallback.choose(this.suite, choices);
        return choice.getStringName();
    }

    public Collection<String> getPossibleStepPairs() {
        return this.possibleStepPairs;
    }

    public Map<String, Collection<String>> getPossibleVariableValues() {
        return this.possibleVVs;
    }

    public Map<String, Collection<String>> getPossibleStates() {
        return this.possibleStates;
    }

    public Map<String, Collection<String>> getPossibleStatePairs() {
        return this.possibleStatePairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.shouldStop = true;
        MainExplorer mainExplorer = this;
        synchronized (mainExplorer) {
            this.notifyAll();
        }
    }
}

