/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import osmo.common.TestUtils;
import osmo.tester.OSMOConfiguration;
import osmo.tester.OSMOTester;
import osmo.tester.coverage.ScoreCalculator;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.explorer.ExplorationConfiguration;
import osmo.tester.explorer.ExplorerAlgorithm;
import osmo.tester.generator.ReflectiveModelFactory;
import osmo.tester.generator.listener.GenerationListener;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.optimizer.CSVCoverageReport;

public class OSMOExplorer {
    private OSMOTester osmo = new OSMOTester();
    private ExplorerAlgorithm algorithm;
    private Collection<Class> classes = new ArrayList<Class>();
    private Collection<GenerationListener> listeners = new ArrayList<GenerationListener>();
    private OSMOConfiguration osmoConfig = new OSMOConfiguration();
    private ExplorationConfiguration config;
    private static int nextId = 1;
    private int id = nextId++;

    public void addModelClass(Class modelClass) {
        this.classes.add(modelClass);
    }

    public OSMOConfiguration getOSMOConfig() {
        return this.osmoConfig;
    }

    public void addListener(GenerationListener listener) {
        this.listeners.add(listener);
    }

    public void explore(ExplorationConfiguration config) {
        this.config = config;
        long start = System.currentTimeMillis();
        this.configureGenerator();
        System.out.println("Starting exploration with " + config.getParallelism() + " parallel processes.");
        this.osmo.generate(config.getSeed());
        this.createScoreReport();
        OSMOTester.writeTrace(this.createReportPath() + "exploration", this.osmo.getSuite().getAllTestCases(), config.getSeed(), this.osmoConfig);
        double seconds = this.calculateTime(start);
        System.out.println("Generation time: " + seconds + "s.");
    }

    private double calculateTime(long start) {
        long end = System.currentTimeMillis();
        long diff = end - start;
        return diff / 1000L;
    }

    private void createScoreReport() {
        boolean printAll = this.config.isPrintAll();
        Map<String, Collection<String>> possibleValues = this.algorithm.getPossibleValues();
        Collection<String> possibleStepPairs = this.algorithm.getPossibleStepPairs();
        Map<String, Collection<String>> possibleStatePairs = this.algorithm.getPossibleStatePairs();
        Map<String, Collection<String>> possibleStates = this.algorithm.getPossibleStates();
        List<TestCase> allTests = this.osmo.getSuite().getAllTestCases();
        TestCoverage tc = new TestCoverage(allTests);
        ScoreCalculator sc = new ScoreCalculator(this.config);
        System.out.println("Generated " + allTests.size() + " tests. Achieved score " + sc.calculateScore(tc));
        CSVCoverageReport report = new CSVCoverageReport(sc);
        String summary = "summary\n";
        summary = summary + tc.coverageString(this.osmo.getFsm(), possibleStepPairs, possibleValues, possibleStates, possibleStatePairs, printAll);
        System.out.println(summary);
        report.process(allTests);
        String totalCsv = report.report();
        totalCsv = totalCsv + summary + "\n";
        TestUtils.write(totalCsv, this.createFullReportPath());
    }

    public String createFullReportPath() {
        return this.createReportPath() + this.id + "-scores.csv";
    }

    private String createReportPath() {
        return "osmo-output/expl-" + this.config.getSeed() + "-" + this.config.getDepth() + "/";
    }

    private void configureGenerator() {
        this.osmo.setPrintCoverage(false);
        if (this.classes.size() > 0) {
            ReflectiveModelFactory factory = new ReflectiveModelFactory();
            for (Class modelClass : this.classes) {
                factory.addModelClass(modelClass);
            }
            this.config.setFactory(factory);
        }
        this.config.fillOSMOConfiguration(this.osmoConfig);
        this.osmoConfig.setExploring(true);
        for (GenerationListener listener : this.listeners) {
            this.osmoConfig.addListener(listener);
        }
        this.osmo.setConfig(this.osmoConfig);
        this.algorithm = new ExplorerAlgorithm(this.config);
        this.osmo.setAlgorithm(this.algorithm);
    }

    public ExplorerAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public TestSuite getSuite() {
        return this.osmo.getSuite();
    }
}

