/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import osmo.common.log.Logger;
import osmo.tester.explorer.ExplorationConfiguration;
import osmo.tester.explorer.ExplorationEndCondition;
import osmo.tester.explorer.ExplorationHelper;
import osmo.tester.explorer.ExplorationState;
import osmo.tester.explorer.trace.TraceNode;
import osmo.tester.generator.MainGenerator;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSMTransition;
import osmo.tester.model.InvocationTarget;

public class PathExplorer
extends RecursiveTask<List<TestCase>> {
    private static final Logger log = new Logger(PathExplorer.class);
    private final ExplorationState state;
    private final int depth;
    private final TraceNode trace;
    private final Collection<FSMTransition> targets;
    private final List<String> script;
    private final ForkJoinPool pool;
    private final ExplorationEndCondition endCondition;

    public PathExplorer(ExplorationState state, int depth, TraceNode trace, Collection<FSMTransition> targets, List<String> script, ForkJoinPool pool) {
        this.state = state;
        this.depth = depth;
        this.trace = trace;
        this.targets = targets;
        this.script = script;
        this.pool = pool;
        this.endCondition = new ExplorationEndCondition(state.getConfig(), state.getSuiteCoverage(), true);
        this.endCondition.init(state.getConfig().getSeed(), null, null);
    }

    @Override
    protected List<TestCase> compute() {
        ArrayList<String> toExplore = new ArrayList<String>();
        for (FSMTransition transition : this.targets) {
            toExplore.add(transition.getStringName());
        }
        ArrayList<PathExplorer> children = new ArrayList<PathExplorer>();
        ArrayList<TestCase> result = new ArrayList<TestCase>();
        for (String explore : toExplore) {
            TraceNode child = this.trace.add(explore, true);
            MainGenerator generator = ExplorationHelper.initPath(this.state, this.script);
            this.initPath(explore, generator);
            int newDepth = PathExplorer.checkDepth(this.state, this.endCondition, generator, this.depth);
            if (newDepth > 0) {
                PathExplorer explorer = this.forkExplorer(explore, child, generator, newDepth);
                children.add(explorer);
                continue;
            }
            TestCase test = generator.getCurrentTest();
            result.add(test);
        }
        for (PathExplorer child : children) {
            Collection tests = (Collection)child.join();
            result.addAll(tests);
        }
        return result;
    }

    private PathExplorer forkExplorer(String explore, TraceNode child, MainGenerator generator, int newDepth) {
        ArrayList<String> newScript = new ArrayList<String>();
        newScript.addAll(this.script);
        newScript.add(explore);
        List<FSMTransition> nowEnabled = generator.getEnabled();
        PathExplorer explorer = new PathExplorer(this.state, newDepth - 1, child, nowEnabled, newScript, this.pool);
        explorer.fork();
        return explorer;
    }

    private void initPath(String explore, MainGenerator generator) {
        List<FSMTransition> enabled = generator.getEnabled();
        for (FSMTransition transition : enabled) {
            if (!transition.getStringName().equals(explore)) continue;
            generator.execute(transition);
            break;
        }
    }

    public static int checkDepth(ExplorationState state, ExplorationEndCondition ec, MainGenerator generator, int toCheck) {
        int maxDepth;
        ExplorationConfiguration config = state.getConfig();
        int maxLength = config.getMaxTestLength();
        TestSuite suite = generator.getSuite();
        int length = suite.getCurrentTest().getAllStepNames().size();
        if (maxLength > 0 && (maxDepth = maxLength - length) < toCheck) {
            toCheck = maxDepth;
        }
        if (ec.endTest(suite, null)) {
            log.d("Depth trimmed due to end condition wanting to stop");
            return 0;
        }
        Collection<InvocationTarget> fsmECs = generator.getFsm().getEndConditions();
        for (InvocationTarget fsmEC : fsmECs) {
            Boolean result = (Boolean)fsmEC.invoke();
            if (!result.booleanValue()) continue;
            log.d("model @EndCondition signalled to stop");
            return 0;
        }
        return toCheck;
    }
}

