/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.explorer.trace;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import osmo.common.TestUtils;
import osmo.common.log.Logger;
import osmo.tester.explorer.trace.TraceNode;

public class DOTWriter {
    private static final Logger log = new Logger(DOTWriter.class);
    private int fileIndex = 0;
    private String ln = System.lineSeparator();
    private final int testIndex;
    public static boolean enabled = false;
    private static final String DIR = "osmo-dot";

    public DOTWriter(int testIndex) {
        this.testIndex = testIndex;
    }

    public int getTestIndex() {
        return this.testIndex;
    }

    public void write(TraceNode traceRoot, int depth, String top) {
        if (!enabled) {
            return;
        }
        ++this.fileIndex;
        String path = "path" + this.testIndex + "_" + this.fileIndex;
        String output = "digraph " + path + " {" + this.ln;
        output = output + this.createPropertyBox(depth, top);
        output = output + this.textFor(traceRoot);
        output = output + "}";
        this.writeToFile(DIR, path, output);
        try {
            String command = "dot -Tpng osmo-dot/" + path + ".dot -o " + DIR + "/" + path + ".png";
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            String errorMsg = "Failed to run DOT. Have you installed Graphviz and put it on path?";
            log.e(errorMsg, e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    private String createPropertyBox(int depth, String current) {
        String label = "depth=" + depth + "\\n";
        label = label + "current = " + current;
        String box = "properties [shape=box, label=\"" + label + "\"]";
        return box;
    }

    private String textFor(TraceNode node) {
        List<TraceNode> children = node.getChildren();
        String output = "";
        boolean exploring = false;
        for (TraceNode child : children) {
            if (exploring != child.isExploring()) {
                exploring = child.isExploring();
                output = exploring ? output + "edge [color=red]" + this.ln : output + "edge [color=black]" + this.ln;
            }
            output = output + node.getName() + " -> " + child.getName() + this.ln;
            output = output + this.textFor(child);
        }
        return output;
    }

    public void writeToFile(String dirPath, String fileName, String content) {
        try {
            Path dir = Paths.get(dirPath, new String[0]);
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = Paths.get(dirPath + "/" + fileName + ".dot", new String[0]);
            Files.write(file, content.getBytes("UTF8"), StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            log.e("Unable to open graph file for writing", e);
            throw new RuntimeException(e);
        }
    }

    public static void deleteFiles() {
        TestUtils.recursiveDelete(DIR);
    }
}

