/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.explorer.trace;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TraceNode {
    private final String name;
    private final boolean exploring;
    private final TraceNode parent;
    private final List<TraceNode> children = new ArrayList<TraceNode>();
    private static Map<String, Integer> counts = new LinkedHashMap<String, Integer>();

    public TraceNode(String name, TraceNode parent, boolean exploring) {
        this.name = name;
        this.parent = parent;
        this.exploring = exploring;
    }

    public TraceNode add(String childName, boolean exploring) {
        Integer count = counts.get(childName);
        if (count == null) {
            count = 0;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        counts.put(childName, count);
        childName = childName + "_" + count;
        TraceNode childNode = new TraceNode(childName, this, exploring);
        this.children.add(childNode);
        return childNode;
    }

    public String getName() {
        return this.name;
    }

    public TraceNode getParent() {
        return this.parent;
    }

    public List<TraceNode> getChildren() {
        return this.children;
    }

    public static void reset() {
        counts.clear();
    }

    public boolean isExploring() {
        return this.exploring;
    }

    public static Map<String, Integer> getCounts() {
        return counts;
    }
}

