/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import osmo.common.OSMOException;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.coverage.ScoreCalculator;
import osmo.tester.generator.SingleInstanceModelFactory;
import osmo.tester.generator.algorithm.FSMTraversalAlgorithm;
import osmo.tester.generator.filter.StepFilter;
import osmo.tester.generator.listener.GenerationListenerList;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.gui.manualdrive.ManualAlgorithm;
import osmo.tester.model.CoverageMethod;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;
import osmo.tester.model.InvocationTarget;
import osmo.tester.model.Requirements;
import osmo.tester.parser.MainParser;
import osmo.tester.parser.ParserResult;
import osmo.tester.scenario.ScenarioFilter;
import osmo.tester.scripter.internal.TestScript;

public class MainGenerator {
    private static final Logger log = new Logger(MainGenerator.class);
    protected final OSMOConfiguration config;
    private FSM fsm;
    private GenerationListenerList listeners;
    private TestSuite suite;
    private TestCaseStep previousStep = null;
    private Requirements reqs;
    private static int testCount = 0;
    private Collection<String> possiblePairs = new LinkedHashSet<String>();
    private final long baseSeed;
    private Long seed = null;
    private ScenarioFilter scenarioFilter;
    private final FSMTraversalAlgorithm algorithm;
    private List<TestScript> scripts = null;
    private TestScript script = null;

    public MainGenerator(long seed, TestSuite suite, OSMOConfiguration config) {
        this.baseSeed = seed;
        this.seed = this.baseSeed;
        this.suite = suite;
        this.config = config;
        this.listeners = config.getListeners();
        this.scenarioFilter = new ScenarioFilter(config.getScenario());
        this.scripts = config.getScripts();
        suite.setKeepTests(config.isKeepTests());
        this.createModelObjects();
        this.algorithm = config.cloneAlgorithm(seed, this.fsm);
    }

    public void generate() {
        log.d("starting generation");
        this.config.initialize(this.seed, this.fsm);
        this.initSuite();
        while (!this.shouldEndSuite()) {
            this.nextTest();
        }
        log.d("Ending suite");
        this.endSuite();
    }

    private boolean shouldEndSuite() {
        int length = this.suite.currentTestNumber();
        if (this.scripts != null) {
            return length >= this.scripts.size();
        }
        if (length < 1) {
            return false;
        }
        return this.config.getSuiteEndCondition().endSuite(this.suite, this.fsm);
    }

    private void createModelObjects() {
        int salt = this.suite.getCoverage().getTotalSteps();
        this.seed = this.baseSeed + (long)salt;
        if (this.scripts != null) {
            this.script = this.scripts.get(this.suite.getAllTestCases().size());
            this.seed = this.script.getSeed();
            this.scenarioFilter = new ScenarioFilter(this.script.toScenario());
        }
        if (this.config.getFactory() instanceof SingleInstanceModelFactory && this.fsm != null) {
            return;
        }
        MainParser parser = new MainParser();
        ParserResult result = parser.parse(this.seed, this.config, this.suite);
        this.fsm = result.getFsm();
        this.invokeAll(this.fsm.getGenerationEnablers());
        this.reqs = result.getRequirements();
        this.suite.initRequirements(this.reqs);
        this.fsm.setRequirements(this.reqs);
    }

    public TestCase nextTest() {
        this.previousStep = null;
        this.createModelObjects();
        this.algorithm.initTest(this.seed);
        log.d("Starting new test generation");
        this.beforeTest();
        TestCase test = this.suite.getCurrentTest();
        while (!this.shouldEndTest()) {
            try {
                boolean shouldContinue = this.nextStep();
                if (shouldContinue) continue;
                log.d("Ending test case");
            }
            catch (AssertionError | RuntimeException e) {
                this.handleError(test, (Throwable)e);
                if (!this.config.shouldStopTestOnError()) continue;
            }
            break;
        }
        try {
            this.lastSteps();
        }
        catch (AssertionError | RuntimeException e) {
            this.handleError(test, (Throwable)e);
        }
        this.afterTest();
        log.d("Finished new test generation");
        return test;
    }

    private boolean shouldEndTest() {
        int length = this.getCurrentTest().getAllStepNames().size();
        if (length < 1) {
            return false;
        }
        if (this.script != null) {
            return length >= this.script.getSteps().size();
        }
        return this.config.getTestCaseEndCondition().endTest(this.suite, this.fsm);
    }

    private void lastSteps() {
        Collection<InvocationTarget> lastSteps = this.fsm.getLastSteps();
        for (InvocationTarget t : lastSteps) {
            t.invoke();
            TestCase test = this.getCurrentTest();
            TestCaseStep step = test.getCurrentStep();
            if (step != null) {
                this.storeUserCoverageValues(step);
                this.suite.storeGeneralState(this.fsm);
            }
            this.listeners.lastStep(t.getMethod().getName());
        }
    }

    private void handleError(TestCase test, Throwable e) {
        test.setFailed(true);
        TestCaseStep step = this.suite.getCurrentTest().getCurrentStep();
        if (step != null) {
            test.getCurrentStep().setFailed(true);
        }
        Throwable unwrap = this.unwrap(e);
        String errorMsg = "Error in test generation:" + unwrap.getMessage();
        if (this.config.isExploring()) {
            if (this.config.isPrintExplorationErrors()) {
                log.w(errorMsg, e);
            }
        } else {
            log.e(errorMsg, e);
        }
        this.listeners.testError(test, unwrap);
        if (this.config.shouldStopTestOnError()) {
            this.suite.storeGeneralState(this.fsm);
            if (!this.config.shouldStopGenerationOnError()) {
                return;
            }
            this.afterTest();
            this.afterSuite();
            if (unwrap instanceof RuntimeException) {
                throw (RuntimeException)unwrap;
            }
            throw new OSMOException(errorMsg, unwrap);
        }
        unwrap.printStackTrace();
        log.d("Skipped test e due to settings (no fail when e)", e);
    }

    private boolean nextStep() {
        List<FSMTransition> enabled = this.getEnabled();
        if (this.config.isTrackOptions()) {
            this.addOptionsFor(this.suite.getCurrentTest().getCurrentStep(), enabled);
        }
        if (enabled.size() == 0) {
            if (this.config.shouldFailWhenNoWayForward()) {
                throw new IllegalStateException("No test step available.");
            }
            log.d("No enabled steps, ending test (fail is disabled).");
            return false;
        }
        FSMTransition next = this.algorithm.choose(this.suite, enabled);
        if (this.algorithm instanceof ManualAlgorithm && next == null) {
            return false;
        }
        log.d("Taking step " + next.getName());
        this.execute(next);
        return !this.checkModelEndConditions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FSMTransition transition) {
        TestCaseStep step = this.suite.addStep(transition);
        this.listeners.stepStarting(step);
        step.start();
        this.invokeAll(transition.getPreMethods(), "pre", transition);
        InvocationTarget target = transition.getTransition();
        try {
            target.invoke();
        }
        catch (Exception e) {
            if (this.config.shouldStopTestOnError()) {
                throw e;
            }
            Throwable unwrapped = this.unwrap(e);
            this.listeners.testError(this.getCurrentTest(), unwrapped);
        }
        finally {
            this.storeUserCoverageValues(step);
            this.suite.storeGeneralState(this.fsm);
        }
        this.listeners.stepDone(step);
        this.invokeAll(transition.getPostMethods(), "post", transition);
        step.end();
        this.previousStep = step;
        this.calculateAddedCoverage(step);
    }

    private void calculateAddedCoverage(TestCaseStep step) {
        ScoreCalculator sc = this.config.getScoreCalculator();
        if (sc == null) {
            return;
        }
        int added = sc.addedScoreFor(this.suite.getCoverage(), this.suite.getCurrentTest());
        step.setAddedCoverage(added);
    }

    private void storeUserCoverageValues(TestCaseStep step) {
        Collection<CoverageMethod> coverages = this.fsm.getCoverageMethods();
        for (CoverageMethod coverage : coverages) {
            String value = coverage.invoke(step);
            String name = coverage.getVariableName();
            this.suite.addUserCoverage(name, value);
            log.d("new coverage: " + name + "=" + value);
        }
    }

    public void endSuite() {
        this.afterSuite();
        log.d("Finished test suite generation");
    }

    public void invokeAll(Collection<InvocationTarget> targets) {
        for (InvocationTarget target : targets) {
            target.invoke();
        }
    }

    protected void invokeAll(Collection<InvocationTarget> targets, String element, FSMTransition transition) {
        for (InvocationTarget target : targets) {
            if (element.equals("pre")) {
                this.listeners.pre(transition);
            }
            if (element.equals("post")) {
                this.listeners.post(transition);
            }
            target.invoke();
        }
    }

    protected boolean checkModelEndConditions() {
        Collection<InvocationTarget> endConditions = this.fsm.getEndConditions();
        for (InvocationTarget ec : endConditions) {
            Boolean result = (Boolean)ec.invoke();
            if (!result.booleanValue()) continue;
            log.d("model @EndCondition signalled to stop");
            return true;
        }
        return false;
    }

    public void initSuite() {
        if (this.suite == null) {
            log.d("No suite object defined. Creating new.");
            this.suite = new TestSuite();
        }
        this.suite.initRequirements(this.reqs);
        this.reqs = this.suite.getRequirements();
        this.fsm.setRequirements(this.reqs);
        this.listeners.suiteStarted(this.suite);
        Collection<InvocationTarget> befores = this.fsm.getBeforeSuites();
        this.invokeAll(befores);
    }

    protected void afterSuite() {
        Collection<InvocationTarget> afters = this.fsm.getAfterSuites();
        this.invokeAll(afters);
        this.listeners.suiteEnded(this.suite);
    }

    public TestCase beforeTest() {
        ++testCount;
        this.config.getTestCaseEndCondition().init(this.seed, this.fsm, this.config);
        TestCase test = this.suite.startTest(this.seed);
        this.listeners.testStarted(this.suite.getCurrentTest());
        Collection<InvocationTarget> befores = this.fsm.getBeforeTests();
        this.invokeAll(befores);
        return test;
    }

    public void afterTest() {
        Collection<InvocationTarget> afters = this.fsm.getAfterTests();
        this.invokeAll(afters);
        TestCase current = this.suite.getCurrentTest();
        this.suite.endTest();
        this.listeners.testEnded(current);
    }

    public List<FSMTransition> getEnabled() {
        ArrayList<FSMTransition> enabled = new ArrayList<FSMTransition>();
        enabled.addAll(this.fsm.getTransitions());
        for (StepFilter filter : this.config.getFilters()) {
            filter.filter(enabled);
        }
        this.scenarioFilter.filter(enabled, this.getCurrentTest().getAllStepNames());
        Collections.sort(enabled);
        Iterator i = enabled.iterator();
        block1: while (i.hasNext()) {
            FSMTransition transition = (FSMTransition)i.next();
            for (InvocationTarget guard : transition.getGuards()) {
                this.listeners.guard(transition);
                Boolean result = (Boolean)guard.invoke();
                if (result.booleanValue()) continue;
                i.remove();
                continue block1;
            }
        }
        return enabled;
    }

    protected Throwable unwrap(Throwable e) {
        while ((e instanceof OSMOException || e instanceof InvocationTargetException) && e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public int getTestCount() {
        return testCount;
    }

    public TestSuite getSuite() {
        return this.suite;
    }

    public TestCase getCurrentTest() {
        return this.suite.getCurrentTest();
    }

    public FSM getFsm() {
        return this.fsm;
    }

    public void addOptionsFor(TestCaseStep step, List<FSMTransition> enabled) {
        String stepName = ".osmo.tester.start.step";
        if (step != null) {
            stepName = step.getName();
        }
        for (FSMTransition transition : enabled) {
            this.possiblePairs.add(stepName + "->" + transition.getStringName());
        }
    }

    public Collection<String> getPossibleStepPairs() {
        return this.possiblePairs;
    }
}

