/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import osmo.common.log.Logger;
import osmo.tester.generator.MainGenerator;
import osmo.tester.model.ModelFactory;
import osmo.tester.model.TestModels;

public class ReflectiveModelFactory
implements ModelFactory {
    private static final Logger log = new Logger(MainGenerator.class);
    private final Collection<Class> classes = new ArrayList<Class>();

    public ReflectiveModelFactory() {
    }

    public ReflectiveModelFactory(Class ... classes) {
        Collections.addAll(this.classes, classes);
    }

    public void addModelClass(Class modelClass) {
        this.classes.add(modelClass);
    }

    @Override
    public void createModelObjects(TestModels models) {
        for (Class aClass : this.classes) {
            try {
                models.add(aClass.newInstance());
            }
            catch (Exception e) {
                log.e("Failed to create a model class instance. Exiting.", e);
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

