/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import osmo.common.Randomizer;
import osmo.common.log.Logger;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.algorithm.FSMTraversalAlgorithm;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;

public class BalancingAlgorithm
implements FSMTraversalAlgorithm {
    private static final Logger log = new Logger(BalancingAlgorithm.class);
    private Map<String, Map<FSMTransition, Integer>> spCoverage = new LinkedHashMap<String, Map<FSMTransition, Integer>>();
    private Randomizer rand = null;

    @Override
    public void init(long seed, FSM fsm) {
    }

    @Override
    public FSMTransition choose(TestSuite suite, List<FSMTransition> choices) {
        TestCaseStep ts = suite.getCurrentTest().getCurrentStep();
        String previous = null;
        previous = ts != null ? ts.getName() : ".osmo.tester.start.step";
        this.initSPCoverage(previous, choices);
        FSMTransition choice = this.checkUncoveredSteps(suite, choices);
        if (choice != null) {
            this.updateSPCoverage(previous, choice);
            return choice;
        }
        choice = this.checkUncoveredSP(previous, choices);
        if (choice != null) {
            this.updateSPCoverage(previous, choice);
            return choice;
        }
        choice = this.weightedChoice(previous, choices);
        this.updateSPCoverage(previous, choice);
        return choice;
    }

    private FSMTransition weightedChoice(String previous, List<FSMTransition> choices) {
        Map<FSMTransition, Integer> map = this.spCoverage.get(previous);
        int[] weights = new int[choices.size()];
        int i = 0;
        int max = 0;
        for (FSMTransition fSMTransition : choices) {
            Integer weight = map.get(fSMTransition);
            weights[i++] = weight;
            if (weight <= max) continue;
            max = weight;
        }
        ++max;
        for (i = 0; i < weights.length; ++i) {
            weights[i] = max - weights[i];
        }
        ArrayList<Integer> scores = new ArrayList<Integer>();
        for (int weight : weights) {
            scores.add(weight);
        }
        int n = this.rand.rawWeightedRandomFrom(scores);
        return choices.get(n);
    }

    private FSMTransition checkUncoveredSteps(TestSuite suite, List<FSMTransition> choices) {
        TestCoverage tc = new TestCoverage();
        tc.addCoverage(suite.getCoverage());
        tc.addCoverage(suite.getCurrentTest().getCoverage());
        Map<String, Integer> coverage = tc.getStepCoverage();
        LinkedHashSet<FSMTransition> options = new LinkedHashSet<FSMTransition>();
        options.addAll(choices);
        Iterator i = options.iterator();
        while (i.hasNext()) {
            FSMTransition next = (FSMTransition)i.next();
            if (!coverage.containsKey(next.getStringName())) continue;
            i.remove();
        }
        log.d("uncovered options:" + options);
        if (options.size() > 0) {
            return (FSMTransition)this.rand.oneOf(options);
        }
        return null;
    }

    private void initSPCoverage(String previous, List<FSMTransition> choices) {
        Map<FSMTransition, Integer> currentSPCoverage = this.spCoverage.get(previous);
        if (currentSPCoverage == null) {
            currentSPCoverage = new LinkedHashMap<FSMTransition, Integer>();
            this.spCoverage.put(previous, currentSPCoverage);
        }
        for (FSMTransition t : choices) {
            if (currentSPCoverage.get(t) != null) continue;
            currentSPCoverage.put(t, 0);
        }
    }

    private FSMTransition checkUncoveredSP(String previous, Collection<FSMTransition> choices) {
        ArrayList<FSMTransition> uncoveredSP = new ArrayList<FSMTransition>();
        uncoveredSP.addAll(choices);
        Map<FSMTransition, Integer> map = this.spCoverage.get(previous);
        for (FSMTransition t : map.keySet()) {
            if (map.get(t) <= 0) continue;
            uncoveredSP.remove(t);
        }
        log.d("Uncovered SP:" + uncoveredSP);
        if (uncoveredSP.size() > 0) {
            return (FSMTransition)this.rand.oneOf(uncoveredSP);
        }
        return null;
    }

    private void updateSPCoverage(String previous, FSMTransition choice) {
        if (previous == null) {
            return;
        }
        Map<FSMTransition, Integer> currentSpCoverage = this.spCoverage.get(previous);
        int count = currentSpCoverage.get(choice);
        currentSpCoverage.put(choice, count + 1);
    }

    @Override
    public void initTest(long seed) {
        this.rand = new Randomizer(seed);
    }

    @Override
    public FSMTraversalAlgorithm cloneMe() {
        BalancingAlgorithm clone = new BalancingAlgorithm();
        return clone;
    }
}

