/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.algorithm;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import osmo.common.Randomizer;
import osmo.common.log.Logger;
import osmo.tester.generator.algorithm.FSMTraversalAlgorithm;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;

public class WeightedBalancingAlgorithm
implements FSMTraversalAlgorithm {
    private static final Logger log = new Logger(WeightedBalancingAlgorithm.class);
    private Map<String, Integer> coverage;
    private Randomizer rand = null;

    @Override
    public void init(long seed, FSM fsm) {
        this.coverage = new LinkedHashMap<String, Integer>(fsm.getTransitions().size());
    }

    @Override
    public FSMTransition choose(TestSuite suite, List<FSMTransition> choices) {
        log.d("choosing from:" + choices);
        Map<FSMTransition, Double> scoreMap = this.countScore(choices);
        ArrayList<FSMTransition> steps = new ArrayList<FSMTransition>();
        double[] tempScores = new double[scoreMap.size()];
        int i = 0;
        for (Map.Entry<FSMTransition, Double> entry : scoreMap.entrySet()) {
            steps.add(entry.getKey());
            tempScores[i++] = entry.getValue();
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (int j = 0; j < tempScores.length; ++j) {
                int n = j;
                tempScores[n] = tempScores[n] * 10000.0;
                if (!(tempScores[j] < 10.0)) continue;
                done = false;
            }
        }
        ArrayList<Integer> scores = new ArrayList<Integer>();
        for (double tempScore : tempScores) {
            scores.add((int)Math.round(tempScore));
        }
        int index = this.rand.rawWeightedRandomFrom(scores);
        FSMTransition transition = (FSMTransition)steps.get(index);
        this.updateCoverage(transition);
        return transition;
    }

    private void updateCoverage(FSMTransition transition) {
        Integer count = this.coverage.get(transition.getStringName());
        if (count == null) {
            count = 1;
        }
        this.coverage.put(transition.getStringName(), count + 1);
    }

    private Map<FSMTransition, Double> countScore(List<FSMTransition> available) {
        int min = Integer.MAX_VALUE;
        for (FSMTransition transition : available) {
            String name = transition.getStringName();
            if (this.coverage.get(name) == null) {
                this.coverage.put(name, 1);
            }
            if (this.coverage.get(name) >= min) continue;
            min = this.coverage.get(name);
        }
        log.d("coverage" + this.coverage);
        LinkedHashMap<FSMTransition, Double> scores = new LinkedHashMap<FSMTransition, Double>();
        Set<String> transitions = this.coverage.keySet();
        for (String name : transitions) {
            FSMTransition transition = null;
            for (FSMTransition a : available) {
                if (!a.getStringName().equals(name)) continue;
                transition = a;
                break;
            }
            if (transition == null) continue;
            double score = transition.getWeight();
            scores.put(transition, score /= (double)this.coverage.get(transition.getStringName()).intValue());
        }
        log.d("weighted scores:" + scores);
        return scores;
    }

    @Override
    public void initTest(long seed) {
        this.rand = new Randomizer(seed);
    }

    @Override
    public FSMTraversalAlgorithm cloneMe() {
        return new WeightedBalancingAlgorithm();
    }
}

