/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import osmo.common.Randomizer;
import osmo.common.log.Logger;
import osmo.tester.generator.algorithm.FSMTraversalAlgorithm;
import osmo.tester.generator.algorithm.WeightComparator;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;

public class WeightedRandomAlgorithm
implements FSMTraversalAlgorithm {
    private static final Logger log = new Logger(WeightedRandomAlgorithm.class);
    private Randomizer rand = null;

    @Override
    public void init(long seed, FSM fsm) {
    }

    @Override
    public FSMTransition choose(TestSuite suite, List<FSMTransition> choices) {
        log.d("choosing from:" + choices);
        Collections.sort(choices, new WeightComparator());
        ArrayList<Integer> weights = new ArrayList<Integer>();
        for (FSMTransition choice : choices) {
            weights.add(choice.getWeight());
        }
        int index = this.rand.rawWeightedRandomFrom(weights);
        return choices.get(index);
    }

    @Override
    public void initTest(long seed) {
        this.rand = new Randomizer(seed);
    }

    @Override
    public FSMTraversalAlgorithm cloneMe() {
        return new WeightedRandomAlgorithm();
    }
}

