/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.endcondition;

import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;

public class Length
implements EndCondition {
    private static final Logger log = new Logger(Length.class);
    private final int length;

    public Length(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be < 0, was " + length + ".");
        }
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean endSuite(TestSuite suite, FSM fsm) {
        int suiteLength = suite.currentTestNumber();
        log.d("finished tests:" + suiteLength + " current steps:" + suite.currentSteps());
        return suiteLength >= this.length;
    }

    @Override
    public boolean endTest(TestSuite suite, FSM fsm) {
        int currentSteps = suite.currentSteps();
        log.d(" et:" + suite.getAllTestCases().size() + " c:" + currentSteps);
        return currentSteps >= this.length;
    }

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration config) {
    }

    public String toString() {
        return "Length{length=" + this.length + '}';
    }

    @Override
    public EndCondition cloneMe() {
        return this;
    }
}

