/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.endcondition;

import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.endcondition.Length;
import osmo.tester.generator.endcondition.Probability;
import osmo.tester.generator.endcondition.logical.And;
import osmo.tester.generator.endcondition.logical.Or;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;

public class LengthProbability
implements EndCondition {
    private EndCondition delegate = null;
    private int min;
    private int max;
    private double probability;

    public LengthProbability(int minLength, double probability) {
        this.init(minLength, 0, probability);
    }

    public LengthProbability(int minLength, int maxLength, double probability) {
        this.init(minLength, maxLength, probability);
    }

    private void init(int minLength, int maxLength, double probability) {
        this.min = minLength;
        this.max = maxLength;
        this.probability = probability;
        if (maxLength < 0) {
            String msg = "Maximum length cannot be negative. Given (" + maxLength + "). Use 0 to disable max length.";
            throw new IllegalArgumentException(msg);
        }
        if (maxLength > 0) {
            if (minLength > maxLength) {
                String msg = "Given minimum length (" + minLength + ") greater than maximum length (" + maxLength + "). " + "Must be the other way around.";
                throw new IllegalArgumentException(msg);
            }
            this.delegate = new Or(new And(new Length(minLength), new Probability(probability)), new Length(maxLength));
        } else {
            this.delegate = new And(new Length(minLength), new Probability(probability));
        }
    }

    @Override
    public boolean endSuite(TestSuite suite, FSM fsm) {
        return this.delegate.endSuite(suite, fsm);
    }

    @Override
    public boolean endTest(TestSuite suite, FSM fsm) {
        return this.delegate.endTest(suite, fsm);
    }

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration config) {
        this.delegate.init(seed, fsm, config);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public double getProbability() {
        return this.probability;
    }

    @Override
    public EndCondition cloneMe() {
        LengthProbability clone = new LengthProbability(this.min, this.max, this.probability);
        clone.delegate = this.delegate.cloneMe();
        return clone;
    }
}

