/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.endcondition;

import osmo.common.Randomizer;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;

public class Probability
implements EndCondition {
    private static final Logger log = new Logger(Probability.class);
    private final double threshold;
    private Randomizer rand = null;

    public Probability(double threshold) {
        if (threshold < 0.0 || threshold > 1.0) {
            throw new IllegalArgumentException(Probability.class.getSimpleName() + " threshold must be between 0 and 1. Was " + threshold + ".");
        }
        this.threshold = threshold;
    }

    public boolean endNow(TestSuite suite, FSM fsm) {
        double v = this.rand.nextDouble();
        log.d("value " + v + " threshold " + this.threshold);
        return v <= this.threshold;
    }

    @Override
    public boolean endSuite(TestSuite suite, FSM fsm) {
        return this.endNow(suite, fsm);
    }

    @Override
    public boolean endTest(TestSuite suite, FSM fsm) {
        return this.endNow(suite, fsm);
    }

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration config) {
        this.rand = new Randomizer(seed);
    }

    public double getThreshold() {
        return this.threshold;
    }

    public String toString() {
        return "Probability{threshold=" + this.threshold + '}';
    }

    public Randomizer getRandomizer() {
        return this.rand;
    }

    @Override
    public EndCondition cloneMe() {
        Probability clone = new Probability(this.threshold);
        return clone;
    }
}

