/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.endcondition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;

public class StateCoverage
implements EndCondition {
    private final String name;
    private Collection<String> required = new LinkedHashSet<String>();

    public StateCoverage(String name, String ... states) {
        this.name = name;
        Collections.addAll(this.required, states);
    }

    @Override
    public boolean endSuite(TestSuite suite, FSM fsm) {
        Collection<String> covered = suite.getCoverage().getStates().get(this.name);
        if (covered == null) {
            covered = new ArrayList<String>();
        }
        ArrayList<String> clone = new ArrayList<String>();
        clone.addAll(this.required);
        clone.removeAll(covered);
        return clone.size() == 0;
    }

    @Override
    public boolean endTest(TestSuite suite, FSM fsm) {
        Collection<String> covered = suite.getCurrentTest().getCoverage().getStates().get(this.name);
        if (covered == null) {
            covered = new ArrayList<String>();
        }
        ArrayList<String> clone = new ArrayList<String>();
        clone.addAll(this.required);
        clone.removeAll(covered);
        return clone.size() == 0;
    }

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration config) {
    }

    @Override
    public EndCondition cloneMe() {
        return this;
    }
}

